% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_2d_wgs.R
\name{calc_2d_wgs}
\alias{calc_2d_wgs}
\title{Return mixture estimation for percentage of normal cells and tumor (1 normal + 2 tumors) with wgs data
Takes \code{baf}, \code{lrr}, \code{n_baf} and \code{nrc}}
\usage{
calc_2d_wgs(baf, lrr, n_baf, nrc)
}
\arguments{
\item{baf}{a numeric vector. Each element is the mean adjusted B allele frequency for that segment, calculated as the mean of baf_tumor/baf_normal/2 for that segment}

\item{lrr}{a numeric vector. Each element is the log ratio of the tumor read count and the normal read count for a segment, defined as log(tumorCount/normalCount)}

\item{n_baf}{a numeric vector}

\item{nrc}{a numeric vector. Each element is the normal read count of the segment divided by two}
}
\value{
\item{sol1}{a numeric vector of length 2. It provides the estimated percentages of normal and tumor from the best solution. The first number is the percentage of the estimated normal percentage. The second number is the percentage of the estimated tumor 1 percentage}
\item{sol2}{a numeric vector of length 2. It provides the estimated percentages of normal and tumor from the second best solution. The first number is the percentage of the estimated normal percentage. The second number is the percentage of the estimated tumor 1 percentage}
}
\description{
Return mixture estimation for percentage of normal cells and tumor (1 normal + 2 tumors) with wgs data
Takes \code{baf}, \code{lrr}, \code{n_baf} and \code{nrc}
}
\keyword{internal}
