% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selecao.R
\name{SG}
\alias{SG}
\title{General Selection Gain Function}
\usage{
SG(
  Var,
  h,
  VF = NULL,
  P = "1",
  DS = NULL,
  Year = NULL,
  method = "pressure",
  verbose = FALSE
)
}
\arguments{
\item{Var}{The column with the name of the variables of interest}

\item{h}{The column with the restricted heritability values}

\item{VF}{The column with the phenotypic variance values (optional)}

\item{P}{The column with the progeny values or selection pressure (optional)}

\item{DS}{The column with the selection differential values (optional)}

\item{Year}{The column with the year of selection (optional)}

\item{method}{The selection method: 'pressure', 'differential',
'genitor_control", or 'year_weighted'}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
A data frame with selection gain results
}
\description{
Computes selection gain using different selection methods
}
\examples{
library(EstimateBreed)

SG(Var = c("A", "B", "C"), h = 0.5, VF = 1.2, P = "10", method = "pressure")
SG(Var = c("A", "B", "C"), h = 0.5, DS = 1.5, method = "differential")
SG(Var = c("A", "B", "C"), h = 0.5, VF = 1.2, P = "10", method = "genitor_control")
SG(Var = c("A", "B", "C"), h = 0.5, VF = 1.2, P = "10", Year = 5, method = "year_weighted")
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
