% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plotPosterior}
\alias{plotPosterior}
\title{Plot posterior density}
\usage{
plotPosterior(
  estimate,
  showEstimate = TRUE,
  dataCutoff = 0.01,
  fileName = NULL
)
}
\arguments{
\item{estimate}{An object as generated using the \code{\link[=computeBayesianMetaAnalysis]{computeBayesianMetaAnalysis()}} function.}

\item{showEstimate}{Show the parameter estimates (mode) and 95 percent confidence intervals?}

\item{dataCutoff}{This fraction of the data at both tails will be removed.}

\item{fileName}{Name of the file where the plot should be saved, for example 'plot.png'. See
the function \link[ggplot2:ggsave]{ggplot2::ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A Ggplot object. Use the \link[ggplot2:ggsave]{ggplot2::ggsave} function to save to file.
}
\description{
Plot posterior density
}
\details{
Plot the density of the posterior distribution of the mu and tau parameters.
}
\examples{
# Simulate some data for this example:
populations <- simulatePopulations()

# Fit a Cox regression at each data site, and approximate likelihood function:
fitModelInDatabase <- function(population) {
  cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
                                            data = population,
                                            modelType = "cox")
  cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
  approximation <- approximateLikelihood(cyclopsFit, parameter = "x", approximation = "custom")
  return(approximation)
}
approximations <- lapply(populations, fitModelInDatabase)
approximations <- do.call("rbind", approximations)

# At study coordinating center, perform meta-analysis using per-site approximations:
estimate <- computeBayesianMetaAnalysis(approximations)
plotPosterior(estimate)

}
\seealso{
\link{computeBayesianMetaAnalysis}
}
