% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepapre_correlation_table.R
\name{prepare_correlation_table}
\alias{prepare_correlation_table}
\title{Prepares a Correlation Table}
\usage{
prepare_correlation_table(df, digits = 2, bold = 0.05, format = "html",
  ...)
}
\arguments{
\item{df}{Data frame containing at least two variables that are either numeric
or logical and at least five observations.}

\item{digits}{The number of digits that you want to report.}

\item{bold}{Indicate the p-Value for for identifying significant correlations
in bold print. Defaults to 0.05. If set to 0, no bold print is being used.}

\item{format}{The format that you want \code{\link[knitr]{kable}} to produce ("html" or "latex")}

\item{...}{Additional parameters that are passed on to \code{\link[knitr]{kable}}}
}
\value{
A list containing four items:
\describe{
 \item{"df_corr"}{A data frame containing the correlations}
 \item{"df_prob"}{A data frame containing the p-values of the correlations}
 \item{"df_n"}{A data frame containing the number of observations used for the correlations}
 \item{"kable_ret"}{The return value provided by \code{\link[knitr]{kable}} containing the formatted table}
}
}
\description{
Reads a data frame and presents Pearson correlations above the diagonal
and Spearman correlations below.
}
\examples{
t <- prepare_correlation_table(mtcars)
t$df_corr
}
