% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countBamInGranges.R
\name{countBam.everted}
\alias{countBam.everted}
\title{Counts everted reads from a single BAM file}
\usage{
countBam.everted(bam.file, granges, index = bam.file, min.mapq = 1)
}
\arguments{
\item{bam.file}{BAM file that needs to be parsed}

\item{granges}{Genomic Ranges object with the location of the bins for which
we want to count the everted reads.}

\item{index}{Index for the BAM files.}

\item{min.mapq}{Minimum mapping quality to include reads.}
}
\value{
A list with the number of reads in each bin.
}
\description{
This is a utility function that is called by the higher level
count.everted.reads. It processes each BAM file individually to generate the
count data.
}
\details{
Most users will not use this function, and it will only be called by the
higher level count.everted.reads. Nevertheless it may be useful on its own
in some cases.
}
\examples{

data(genes.hg19)
bam_file <- system.file('extdata/minimum_1_25630000_25650000.bam',
                        package = 'ExomeDepth')
genes.hg19.small <- subset(genes.hg19, grepl(pattern = '^TTC34|^RHD', genes.hg19[['name']]))
my_range <- GenomicRanges::GRanges(paste0(genes.hg19.small$chromosome, ":",
                       genes.hg19.small$start, '-', genes.hg19.small$end))
print(my_range)
print(countBam.everted (granges = my_range, bam.file = bam_file, min.mapq = 0))
}
\seealso{
count.everted.reads
}
