% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram_image.R
\name{histogram_image}
\alias{histogram_image}
\title{Create a histogram from image bands
(Criar um histrograma a partir das bandas das imagens)}
\usage{
histogram_image(im,layout=2,lim=1000,BandNames=NULL)
}
\arguments{
\item{im}{:Este objeto deve conter uma imagem (This object must contain an image ).}

\item{layout}{: Valor numerico variando entre 1 e 3 para se ter diferentes layouts
(Numeric value ranging between 1 and 3 to have different layouts).}

\item{lim}{: Refere-se ao numero maximo de pixels que se deseja considerar para
obter o histograma. Se for NULL todos os pixels serao considerados (refers to the maximum number
 of pixels considered to obtain the histogram. If NULL all pixels will be considered).}

\item{BandNames}{:Refere-se ao nome das bandas (Refers to the bands names)}
}
\value{
Retorna histogramas a partir das bandas (Return histograms from the bands of the images).
}
\description{
This function allows you to create histograms from the bands of the images
(Esta funcao permite criar histogramas a partir das bandas das imagens).
}
\examples{
\donttest{
end=example_image(6)
im=read_image(end,plot=TRUE)
histogram_image(im,layout = 1)
histogram_image(im,layout = 2)
histogram_image(im,layout = 3)
histogram_image(im,BandNames = c("Azul","Verde",
"Vermelho","IR","SWIR"))



########################################################
###' Abrindo o endereco de bandas de imagens de satelite
########################################################
end1=example_image(14) #Banda de azul
end2=example_image(15) #Banda de verde
end3=example_image(16) #Banda de vermelho
end4=example_image(17) #Banda de IR
end5=example_image(18) #Banda de SWIR

########################################################
###' Abrindo bandas de imagens de satelite
########################################################
B1=read_image(end1,plot=TRUE)
B2=read_image(end2,plot=TRUE)
B3=read_image(end3,plot=TRUE)
B4=read_image(end4,plot=TRUE)
B5=read_image(end5,plot=TRUE)

########################################################
###' Juntando as bandas em uma imagem
########################################################
im=join_bands(imgs = list(B1,B2,B3,B4,B5))
tif_info(im)
histogram_image(im)
}
}
\seealso{
\code{\link{segmentation_logit}}
}
