% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_edge_t_stat.R
\name{compute_edge_t_stat}
\alias{compute_edge_t_stat}
\title{Computing edge length, t statistics and t percentiles}
\usage{
compute_edge_t_stat(
  data_type1,
  data_type2,
  network,
  type1_name = "Type1",
  type2_name = "Type2",
  alpha_t_test = 0.05,
  save_edge_res = FALSE,
  save_dir = here::here()
)
}
\arguments{
\item{data_type1}{data.frame for phenotype 1. Each row corresponds to a vertex feature.
Each column corresponds to a sample. The first column are the numeric vertex indices.}

\item{data_type2}{data.frame for phenotype 2, in the same format as \emph{data_type1}.}

\item{network}{An \link[igraph]{igraph-package} graph object. It will be converted to an undirected graph by default.}

\item{type1_name}{The name for phenotype 1, used for naming files of the results.}

\item{type2_name}{The name for phenotype 2.}

\item{alpha_t_test}{Significance level of the t test for each edge. It does not affect the computation of AT1 and AT2.}

\item{save_edge_res}{Logical. Whether the results should be saved. Set to TRUE if you plan to conduct analysis on the t statistics of the edges.}

\item{save_dir}{Directory to save the results. Results are saved in a subfolder \emph{result_ExprNet} will be created under the directory.}
}
\value{
A list consisting of \emph{edge_t_stat} and \emph{edge_dist_mat}.
\emph{edge_t_stat} is a data.frame storing results of the t test.
Each row gives the following properties of an edge: Vertex1(V1), Vertex2(V2), (mean, sd) of each type, difference in means, t statistic, p-value, percentile of the t statistic.
\emph{edge_dist_mat} is a matrix containing all the sample distances of each edge.
Each column is the computed edge length of an edge \emph{"vertex1-vertex2"} for all samples (Type1 and Type2). The first column is the sample label.
}
\description{
Given data for two phenotypes and a network, compute the length of each edge and conduct two-sample t tests on all edges.
}
\examples{
library(ExprNet)
network <- network_demo
data_type1 <- data_LGG_demo
data_type2 <- data_GBM_demo

# compute the t-statistics and percentiles
res <- compute_edge_t_stat(data_type1, data_type2, network, type1_name = "LGG", type2_name = "GBM")
res
}
