% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SSRTB.R
\name{SSRTB}
\alias{SSRTB}
\alias{dSSRTB}
\alias{eSSRTB}
\alias{lSSRTB}
\alias{pSSRTB}
\alias{qSSRTB}
\alias{rSSRTB}
\title{The standard symmetric-reflected truncated beta (SSRTB) distribution.}
\usage{
dSSRTB(x, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

pSSRTB(q, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

qSSRTB(p, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

rSSRTB(n, shape1 = 2, shape2 = 3, params = list(shape1, shape2), ...)

eSSRTB(X, w, method = "numerical.MLE", ...)

lSSRTB(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2),
  logL = TRUE, ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{shape1,shape2}{Shape parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical; if TRUE, lSSRTB gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dSSRTB gives the density, pSSRTB the distribution function,
qSSRTB the quantile function, rSSRTB generates random variables,
eSSRTB estimates the parameters and lSSRTB provides the log-likelihood.
}
\description{
Density, distribution, quantile, random number
generation and parameter estimation functions for the SSRTB distribution. Parameter estimation can be
based on a weighted or unweighted i.i.d sample and can be carried out numerically.
}
\details{
No details as of yet.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rSSRTB(n=500, shape1=2, shape2=10)
est.par <- eSSRTB(X); est.par
plot(est.par)

#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dSSRTB(den.x,shape1=est.par$shape1,shape2=est.par$shape2)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.2*max(den.y)))
lines(den.x, den.y, col="blue")
lines(density(X), lty=2)

# Extracting shape parameters
est.par[attributes(est.par)$par.type=="shape"]

# log-likelihood function
lSSRTB(X,param = est.par)
}
\author{
Haizhen Wu.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

