% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Radiation.R
\name{DH}
\alias{DH}
\title{Daylight Hours (N)}
\usage{
DH(omega_s)
}
\arguments{
\item{omega_s}{A numeric scalar that denotes the sunset hour angle [rad].}
}
\value{
The function returns the value of daylight hours as a numeric scalar.
}
\description{
\code{DH} returns the value of daylight hours.
}
\details{
This is a function to calculate the daylight hours.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
DH(omega_s = 1.527)

}
\seealso{
\code{\link{SunHA}}.
}
