% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aggregation.R
\name{Aggregation}
\alias{Aggregation}
\title{Compute Aggregates}
\usage{
Aggregation(
  data,
  aggVar,
  weightVar = rep(NA, length(aggVar)),
  year = "Year",
  relationDF = FAOcountryProfile[, c("FAOST_CODE", "M49_FAOST_CODE")],
  aggMethod = rep("sum", length(aggVar)),
  applyRules = TRUE,
  keepUnspecified = TRUE,
  unspecifiedCode = 0,
  thresholdProp = rep(0.65, length(aggVar))
)
}
\arguments{
\item{data}{The data frame containing the country level data.}

\item{aggVar}{The vector of names of the variables to be
aggregated.}

\item{weightVar}{The vector of names of the variables to be used
as weighting when the aggregation method is weighted.}

\item{year}{The column containing the time information.}

\item{relationDF}{A relational data frame which specifies the
territory and the mother country. At least one column must have 
a corrispondent variable name in the dataset.}

\item{aggMethod}{Can be a single method for all data or a vector
specifying different method for each variable. The method can be 
"sum", "mean", "weighted.mean".}

\item{applyRules}{Logical, specifies whether the 
\code{thresholdProp} rule must be applied or not.}

\item{keepUnspecified}{Whether countries with unspecified region
should be aggregated into an "Unspecified" group or simply
drop. Default to create the new group.}

\item{unspecifiedCode}{The output code of the unspecified group.}

\item{thresholdProp}{The vector of the missing threshold for the 
aggregation rule to be applied. The default is set to only compute 
aggregation if there are more than 65 percent of data available (0.65).}
}
\description{
The function takes a relational data frame and computes the aggregation
based on the relation specified.
}
\details{
The length of \code{aggVar}, \code{aggMethod}, \code{weightVar},
\code{thresholdProp} must be the same.

Aggregation should not be computed if insufficient
countries have reported data. This corresponds to the argument
\code{thresholdProp} which specifies the percentage which of
country must report data (both for the variable to be aggregated and
the weighting variable).
}
\examples{
## example.df = data.frame(FAOST_CODE = rep(c(1, 2, 3), 2),
##                        Year = rep(c(2010, 2011), c(3, 3)),
##                        value = rep(c(1, 2, 3), 2),
##                        weight = rep(c(0.3, 0.7, 1), 2))

## Lets aggregate country 1 and 2 into one country and keep country
## 3 seperate.
## relation.df = data.frame(FAOST_CODE = 1:3, NEW_CODE = c(1, 1, 2))

}
