% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_countrycodes.R
\name{translate_countrycodes}
\alias{translate_countrycodes}
\alias{translateCountryCode}
\title{A function to translate between different country coding systems}
\usage{
translate_countrycodes(
  data,
  from = c("FAO", "M49", "ISO2", "ISO3"),
  to = c("M49", "FAO", "ISO2", "ISO3", "name"),
  oldCode,
  reset_cache = FALSE
)

translateCountryCode(
  data,
  from = c("FAO", "M49", "ISO2", "ISO3"),
  to = c("M49", "FAO", "ISO2", "ISO3", "name"),
  oldCode,
  reset_cache = FALSE
)
}
\arguments{
\item{data}{The data frame}

\item{from}{The name of the old coding system}

\item{to}{The name of the new coding system}

\item{oldCode}{The column name of the old country coding scheme}

\item{reset_cache}{logical. Whether to pull data from FAOSTAT directly
instead of caching}
}
\description{
The function translate any country code scheme to another if both are in the
are among the types present in the FAO API. If you require other codes or
conversion of country names to codes, consider the \code{countrycodes} package.
}
