% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagn_plot}
\alias{diagn_plot}
\title{Plot convergence of best/median/mean/other summary log posteriors in time}
\usage{
diagn_plot(res, FUN = median, conf = 0.95, burnin = 0, window = 5, ylim = NULL)
}
\arguments{
\item{res}{Object corresponding gmjmcmc output}

\item{FUN}{The summary statistics to check convergence}

\item{conf}{which confidence intervals to plot}

\item{burnin}{how many first populations to skip}

\item{window}{sliding window for computing the standard deviation}

\item{ylim}{limits for the plotting range, if unspecified, min and max of confidence intervals will be used}
}
\value{
A list of summary statistics for checking convergence with given confidence intervals
}
\description{
Plot convergence of best/median/mean/other summary log posteriors in time
}
\examples{
result <- gmjmcmc(matrix(rnorm(600), 100), P = 2, gaussian.loglik, NULL, c("p0", "exp_dbl"))
diagnstats <- diagn_plot(result)

}
