% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcomb.R
\name{pcomb}
\alias{pcomb}
\title{Pair Correlation of Molecular Brightness}
\usage{
pcomb(img, nPoints = 25000, type = "d", dr = 1, w = 100, pcf = TRUE)
}
\arguments{
\item{img}{The image to analyze.}

\item{nPoints}{The size of the sub-vectors in which the input vectors will be divided. This number must be less than N/2.}

\item{type}{By defautl 'd'. The possible values are 'd', 'a' and 'c'}

\item{dr}{Is the distance between the two columns that will be correlated. For a value of deltar = 3, the columns are correlated as follows: (1,4), (2,5), ..., (n-3, n), with n as the last column.}

\item{w}{Range value that is used to calculate the brightness in the image.}

\item{pcf}{A boolean variable that determines whether the pcf analysis is performed on the brightness carpet or not.}
}
\value{
A list containing the Brightness Carpet and the Pair Correlation of that carpet
}
\description{
Performs the pair correlation of molecular brightness (pCOMB) analysis.
}
\details{
With the Pair Correlation of Molecular Brightness (pCOMB) method, one can distinguish between different homo-oligomeric species of the same molecule coexisting in the same microenvironment, while separately and specifically tracking each species' moblity across the cellular compartments. This technique amplifies the signal from the brightest species present and filters the dynamics of the extracted oligomeric population based on arrival time between two locations. This method is suitable for mapping the impact oligomerization on transcription factor dynamics.
The resulting intensity fluctuations, pCF, are transformed into brightness fluctuations using B = (sigma^2)/mean, and the pair correlation analysis is then performed on the brightness fluctuations along the line scan , at a distance (delta(r)).

If the pcf is set as FALSE the pComb data will not be generated and will be NULL. In order to generate that data the pcf function must be used on the BCarpet data.
}
\examples{
# Pair Correlation Function Autocorrelacion no pcf analysis
dmv2 <- data.matrix(v2DataSet)
pC <- pcomb(dmv2[1:32,1:2001], nPoints = 1000, type = 'd', dr = 10, w = 2, pcf = FALSE)

\donttest{
# Pair Correlation Function Autocorrelacion with pcf analysis
dmv2 <- data.matrix(v2DataSet)
pC <- pcomb(dmv2, nPoints = 5000, type = 'd', dr = 10, w = 100)
di <- dim(pC$pComb)
tau <- (1:(di[2]))

# Plot the result
library("fields")
image.plot( x = 1:di[1], y = log10(tau), z = pC$pComb, main = "pComb",
xlab = "Pixel", ylab = "Logarithmic tau",
cex.lab = 1.2, cex.main = 1.2, cex.axis = 1)
}
}
\seealso{
\code{\link{fcs}, \link{pcf}}
}
\author{
Raul Pinto Camara.
}
