% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.coxph}
\alias{average.power.coxph}
\title{Compute the average power of many Cox regression models}
\usage{
average.power.coxph(n, alpha, logHR, v)
}
\arguments{
\item{n}{number of event (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{logHR}{log hazard ratio (vector)}

\item{v}{variance of predictor variable (vector)}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute the average power of many Cox regression models for a given number of events, p-value threshold, vector of effect sizes (log hazard ratio),and variance of predictor variables
}
\examples{
logHR = log(rep(c(1, 2),c(900, 100)));
v = rep(1, 1000);
average.power.coxph(n = 50, alpha = 0.05, logHR = logHR, v = v)
}
\references{
Hsieh, FY and Lavori, Philip W (2000) Sample-size calculations for the Cox proportional hazards regression model with non-binary covariates. Controlled Clinical Trials 21(6):552-560.
}
\seealso{
\code{\link{power.cox}} for more details about power calculation of single-predictor Cox regression model
}
