% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurfaceTraction.R
\name{SurfaceTraction}
\alias{SurfaceTraction}
\title{SurfaceTraction.}
\usage{
SurfaceTraction(meshP, SFTensile, SFShear, Length, Thick, area)
}
\arguments{
\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{SFTensile}{Magnitude of tensile surface traction}

\item{SFShear}{Magnitude of positive shear traction}

\item{Length}{Truss length}

\item{Thick}{Triangle element thickness}

\item{area}{Triangle element area}
}
\value{
List of element matrices containing surface forces.
\item{SurfT}{List of surface forces for each element.}
}
\description{
Element Surface Traction - generates the column matrix for uniformly distributed surface traction. If surface traction is not present, assign SFTensile and SFShear a value of 0.
}
\examples{
data(triMesh)
data(dime)

meshP = triMesh$MeshPts$p
SFShear = 0
SFTensile = 0
Thick = 0.001
Length = dime$TrussLength
area = dime$Area

SurfTrac = SurfaceTraction(meshP, SFTensile, SFShear, Length, Thick, area)

}
