% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FFTreesdata_doc.R
\docType{data}
\name{car}
\alias{car}
\title{Car acceptability data}
\format{
A data frame containing 1728 cars (rows) and 7 variables (columns).

\describe{
  \item{buying.price}{price for buying the car, Factor (high, low, med, vhigh)}
  \item{maint.price}{price of the maintenance, Factor (high, low, med, vhigh)}
  \item{doors}{number of doors, Factor (2, 3, 4, 5more)}
  \item{persons}{capacity in terms of persons to carry, Factor (2, 4, more)}
  \item{luggage}{the size of luggage boot, Factor (big, med, small)}
  \item{safety}{estimated safety of the car, Factor (high, low, med)}
  \item{acceptability}{\emph{Criterion}: Category of acceptability rating.

  Values: \code{unacc}/ \code{vgood}/ \code{good}/ \code{acc}}
}
}
\source{
\url{http://archive.ics.uci.edu/ml/datasets/Car+Evaluation}

Original creator and donor:

Marko Bohanec and Blaz Zupan
}
\usage{
car
}
\description{
A dataset on car evaluations based on basic features, derived from a simple hierarchical decision model.
}
\details{
The criterion variable is a car's \code{acceptability} rating.


The \emph{criterion} for this dataset has not yet been binarized. Before using it with an \emph{FFTree}, this necessary prerequisite step should be completed based on individual preferences.
}
\references{
Bohanec, M., Rajkovic, V. (1990): Expert system for decision making.
\emph{Sistemica}, \emph{1} (1), 145--157.
}
\seealso{
Other datasets: 
\code{\link{blood}},
\code{\link{breastcancer}},
\code{\link{contraceptive}},
\code{\link{creditapproval}},
\code{\link{fertility}},
\code{\link{forestfires}},
\code{\link{heart.cost}},
\code{\link{heart.test}},
\code{\link{heart.train}},
\code{\link{heartdisease}},
\code{\link{iris.v}},
\code{\link{mushrooms}},
\code{\link{sonar}},
\code{\link{titanic}},
\code{\link{voting}},
\code{\link{wine}}
}
\concept{datasets}
\keyword{datasets}
