% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modGBpop.R
\name{modGBpop}
\alias{modGBpop}
\title{Green-Book module - Generate population data for GB module.}
\usage{
modGBpop(
  popType = "VOL",
  popTabs = popTables(),
  popTabIDs = popTableIDs(),
  popFilter = popFilters(),
  pltassgn = NULL,
  pltassgnid = "PLT_CN",
  dsn = NULL,
  pjoinid = "CN",
  areawt = "CONDPROP_UNADJ",
  nonsamp.vfilter.fixed = TRUE,
  adj = "samp",
  unitvar = NULL,
  unitarea = NULL,
  areavar = "ACRES",
  strata = TRUE,
  stratalut = NULL,
  strvar = "STRATUMCD",
  savedata = FALSE,
  saveobj = FALSE,
  objnm = "GBpopdat",
  unit_opts = NULL,
  strata_opts = NULL,
  savedata_opts = NULL,
  GBdata = NULL,
  pltdat = NULL,
  stratdat = NULL,
  auxdat = NULL,
  gui = FALSE,
  ...
)
}
\arguments{
\item{popType}{String. Type of evaluation(s) to include in population data.
Note: currently only c('CURR', 'VOL', 'LULC', 'DWM') 
are available. See details below for descriptions of each.}

\item{popTabs}{List of population tables the user would like returned.
See help(popTables) for a list of options.}

\item{popTabIDs}{List of unique IDs corresponding to the population tables
that the user has requested. See help(popTableIDs) for a list of
options.}

\item{popFilter}{List of population filters. See help(popFilters) for a 
list of options.}

\item{pltassgn}{DF/DT, Optional. R object, sf R object, comma-delimited
file(.csv), layer or spatial layer in dsn, or shapefile(.shp). Plot-level
assignment of estimation unit and/or strata, with one record for each plot.}

\item{pltassgnid}{String.}

\item{dsn}{String. Name of database where tree, cond, and plot-level tables
reside.  The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html).}

\item{pjoinid}{String. Join variable in plot to match pltassgnid. Does not
need to be uniqueid. If using most current XY coordinates for plot
assignments, use identifier for plot (e.g., PLOT_ID).}

\item{areawt}{String. Name of variable for summarizing area weights (e.g.,
CONDPROP_UNADJ).}

\item{nonsamp.vfilter.fixed}{Logical. Temporary parameter for vegetation data fix.}

\item{adj}{String. How to calculate adjustment factors for nonsampled
(nonresponse) conditions based on summed proportions for by plot ('samp',
'plot').  'samp' - adjustments are calculated at strata/estimation unit
level; 'plot' - adjustments are calculated at plot-level. Adjustments are
only calculated for annual inventory plots (DESIGNCD=1).}

\item{unitvar}{String. Name of the estimation unit variable in unitarea and
cond or pltassgn data frame with estimation unit assignment for each plot
(e.g., 'ESTN_UNIT'). Optional if only one estimation unit.}

\item{unitarea}{Numeric or DF. Total area by estimation unit. If only 1
estimation unit, include number of total acreage for the area of interest or
a data frame with area and estimation unit. If more than one estimation
unit, provide a data frame of total area by estimation unit, including
unitvar and areavar.}

\item{areavar}{String. Name of area variable in unitarea. Default="ACRES".}

\item{strata}{Logical. If TRUE, include information for post-stratification.}

\item{stratalut}{DF/DT. If strata=TRUE, look-up table with pixel counts or
area by strata or proportion or area ('strwt') by strata (and estimation
unit).  If 'strwt' is not included, set getwt=TRUE and getwtvar as the name
of variable to calculate weights from (e.g., pixel counts).}

\item{strvar}{String. If strata=TRUE, name of the strata variable in
stratalut and cond or pltassgn data frame with stratum assignment for each
plot (Default = 'STRATUMCD').}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{saveobj}{Logical. If TRUE, saves returned list object to outfolder.}

\item{objnm}{String. Name of *.rds object.}

\item{unit_opts}{List. See help(unit_options()) for a list of options.}

\item{strata_opts}{List. See help(strata_options()) for a list of options.
Only used when strata = TRUE.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{GBdata}{R List object. Output data list components from
FIESTA::anGBdata().}

\item{pltdat}{R List object. Output data list components from
FIESTA::spGetPlots().}

\item{stratdat}{R List object. Output data list components from
FIESTA::spGetStrata().}

\item{auxdat}{R List object. Output data list components from
FIESTA::spGetAuxiliary().}

\item{gui}{Logical. If gui, user is prompted for parameters.}

\item{...}{For extendibility.}
}
\value{
A list with population data for Green-Book estimates.

\item{condx}{ Data frame. Condition-level data including plot-level
assignment of estimation unit and stratum (if strata=TRUE), condition
proportion adjustment factor (cadjfac), and adjusted condition proportions
(CONDPROP_ADJ). } 
\item{cuniqueid}{ String. Unique identifier of plot in condx and pltcondx. } 
\item{condid}{ String. Unique identifier of condition in condx and pltcondx. } 
\item{treex}{ Data frame. Tree data within population, used for estimation, 
including trees per acre adjustment factor (tadjfac), and adjusted trees per 
acre (TPA_ADJ) (if treef is included). }
\item{tuniqueid}{ String. Unique identifier of plot in treex (if treef is
included). } 
\item{ACI.filter}{ String. If ACI=FALSE, ACI.filter="COND_STATUS_CD == 1". } 
\item{unitarea}{ String. Returned table of area by estimation unit. } 
\item{unitvar}{ String. Variable name for estimation unit. } 
\item{strlut}{ String. Strata-level table with pixel counts by strata 
(P1POINTCNT), strata weights (strwt), number of plots by strata (n.strata), 
total number of plots in estimation unit (n.total), sum of condition proportions 
(_UNADJ_SUM), area adjustments (*_ADJFAC), total area, and area expansion 
by strata (EXPNS). } 
\item{strvar}{ String. Variable name for strata. If strata=FALSE, 
strvar="ONESTRAT". }
\item{expcondtab}{ String. If ACI=FALSE, ACI.filter="COND_STATUS_CD == 1".} 
\item{plotsampcnt}{ Data frame. Number of plots by PLOT_STATUS_CD. }
\item{condsampcnt}{ Data frame. Number of conditions by COND_STATUS_CD. }
\item{states}{ String. State names in dataset. } 
\item{invyrs}{ String. Range of inventory years in dataset. }

\item{stratdat}{ Data frame. Strata information by estimation unit. }
\tabular{lll}{ \tab \bold{Variable} \tab \bold{Description}\cr 
\tab unitvar \tab estimation unit \cr 
\tab strvar \tab stratum value \cr \tab strwtvar \tab number of pixels by 
strata and estimation unit \cr 
\tab n.strata \tab number of plots in strata (after totally nonsampled 
plots removed) \cr 
\tab n.total \tab number of plots for estimation unit \cr 
\tab strwt \tab proportion of area (or plots) by strata and estimation 
unit (i.e., strata weight) \cr 
\tab CONDPROP_UNADJ_SUM \tab summed conditionproportion by strata and 
estimation unit \cr 
\tab CONDPROP_ADJFAC \tab adjusted condition proportion by strata after 
nonsampled plots removed \cr 
\tab AREA_USED \tab total area of estimation unit \cr 
\tab expfac \tab strata-level expansion factor after nonsampled plots and 
conditions removed (AREA_USED/n.strata) \cr 
\tab EXPNS \tab strata-level area expansions (expfac * strwt)\cr }

Table(s) are also written to outfolder.
}
\description{
Generates population data for generating 'green-book' estimates (Scott et
al. 2005).  Plots that are totally nonsampled are excluded from estimation
dataset. Next, an adjustment factor is calculated by strata to adjust for
nonsampled (nonresponse) conditions that have proportion less than 1.
Attributes adjusted to a per-acre value are summed by plot, divided by the
adjustment factor, and averaged by stratum.  Strata means are combined using
the strata weights and then expanded to using the total land area in the
population.
}
\details{
Population types \cr \tabular{lll}{ \tab \bold{popType}
\bold{Description}\cr 
\tab ALL \tab Population data, inluding nonsampled plots.\cr 
\tab CURR \tab Population data for area estimates, excluding nonsampled 
plots.\cr 
\tab VOL \tab Population data for area/tree estimates, excluding 
nonsampled plots.\cr 
\tab LULC \tab Population data for land use/land cover transitional estimates, 
including only plots with previous measurements and excluding nonsampled 
plots.\cr }

If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr \tabular{llll}{ \tab \bold{Data} \tab
\bold{Variable} \tab \bold{Description}\cr 
\tab tree \tab tuniqueid \tab Unique identifier for each plot in tree 
table.\cr \tab \tab CONDID \tab Unique identifier of each condition on plot.  
Set CONDID=1, if only 1 condition per plot.\cr 
\tab \tab TPA_UNADJ \tab Number of trees per acre each sample tree represents 
(e.g., DESIGNCD=1: TPA_UNADJ=6.018046 for trees on subplot; 74.965282 for 
trees on microplot).\cr 
\tab cond \tab cuniqueid \tab Unique identifier for each plot in cond 
table.\cr 
\tab \tab CONDID \tab Unique identfier of each condition on plot. Set 
CONDID=1, if only 1 condition per plot.\cr 
\tab \tab CONDPROP_UNADJ \tab Unadjusted proportion of condition on each 
plot. Set CONDPROP_UNADJ=1, if only 1 condition per plot.\cr 
\tab \tab COND_STATUS_CD \tab Status of each forested condition on
plot (i.e. accessible forest, nonforest, water, etc.)\cr 
\tab \tab NF_COND_STATUS_CD \tab If ACI=TRUE. Status of each nonforest 
condition on plot (i.e. accessible nonforest, nonsampled nonforest)\cr 
\tab \tab SITECLCD \tab If landarea=TIMBERLAND. Measure of site 
productivity.\cr 
\tab \tab RESERVCD \tab If landarea=TIMBERLAND. Reserved status.\cr 
\tab \tab SUBPROP_UNADJ \tab Unadjusted proportion of subplot conditions 
on each plot. Set SUBPROP_UNADJ=1, if only 1 condition per subplot.\cr 
\tab \tab MICRPROP_UNADJ \tab If microplot tree attributes. Unadjusted 
proportion of microplot conditions on each plot. Set MICRPROP_UNADJ=1, 
if only 1 condition per microplot.\cr 
\tab \tab MACRPROP_UNADJ \tab If macroplot tree attributes. Unadjusted 
proportion of macroplot conditions on each plot. Set MACRPROP_UNADJ=1, 
if only 1 condition per macroplot.\cr 
\tab pltassgn \tab pltassgnid \tab Unique identifier for each plot in 
pltassgn.\cr 
\tab \tab STATECD \tab Identifies state each plot is located in.\cr 
\tab \tab INVYR \tab Identifies inventory year of each plot.\cr 
\tab \tab PLOT_STATUS_CD \tab Status of each plot (i.e. sampled, nonsampled).  
If not included, all plots are assumed as sampled.\cr }

For available reference tables: sort(unique(FIESTAutils::ref_codes$VARIABLE)) \cr
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions. It is calculated for each estimation unit by strata.
by summing the unadjusted proportions of the subplot, microplot, and
macroplot (i.e. *PROP_UNADJ) and dividing by the number of plots in the
strata/estimation unit).

An adjustment factor is determined for each tree based on the size of the
plot it was measured on. This is identified using TPA_UNADJ as follows:

\tabular{llr}{ \tab \bold{PLOT SIZE} \tab \bold{TPA_UNADJ} \cr \tab SUBPLOT
\tab 6.018046 \cr \tab MICROPLOT \tab 74.965282 \cr \tab MACROPLOT \tab
0.999188 \cr }

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr If ACI=TRUE, the nonsampled nonforest conditions are
removed as well and accounted for in adjustment factor.  This is if you are
interested in estimates for all lands or nonforest lands in the
All-Condition-Inventory.

unitcombine:\cr If TRUE and less than 2 plots in any one estimation unit,
all estimation units with 10 or less plots are combined. The current method
for combining is to group the estimation unit with less than 10 plots with
the estimation unit following in consecutive order (numeric or
alphabetical), restrained by survey unit (UNITCD) if included in dataset,
and continuing until the number of plots equals 10. If there are no
estimation units following in order, it is combined with the estimation unit
previous in order.

stratcombine:\cr If TRUE and less than 2 plots in any one strata class
within an esimation unit, all strata classes with 2 or less plots are
combined. The current method for combining is to group the strata with less
than 2 plots with the strata class following in consecutive order (numeric
or alphabetical), restrained by estimation unit (if unitcombine=FALSE), and
continuing until the number of plots equals 10. If there are no strata
classes following in order, it is combined with the estimation unit previous
in order.
}
\examples{
GBpopdat <- modGBpop(
popTabs = list(cond = FIESTA::WYcond,  
               tree = FIESTA::WYtree,        
               seed = FIESTA::WYseed),      
popTabIDs = list(cond = "PLT_CN"),            
pltassgn = FIESTA::WYpltassgn,  
pltassgnid = "CN",        
pjoinid = "PLT_CN",         
unitarea = FIESTA::WYunitarea,
unitvar = "ESTN_UNIT",        
strata = TRUE,           
stratalut = WYstratalut,    
strata_opts = strata_options(getwt = TRUE)   
)

str(GBpopdat, max.level = 1)
}
\references{
Scott, Charles T.; Bechtold, William A.; Reams, Gregory A.;
Smith, William D.; Westfall, James A.; Hansen, Mark H.; Moisen, Gretchen G.
2005. Sample-based estimators used by the Forest Inventory and Analysis
national information management system. Gen. Tech. Rep. SRS-80. Asheville,
NC: U.S. Department of Agriculture, Forest Service, Southern Research
Station, p.53-77.
}
\author{
Tracey S. Frescino, Paul L. Patterson, Elizabeth A. Freeman
}
\keyword{data}
