% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spAlignRast.R
\name{spAlignRast}
\alias{spAlignRast}
\title{Spatial - Aligns a list of raster layer(s) based on a reference raster.}
\usage{
spAlignRast(
  ref_rastfn,
  rastlst,
  resample_methodlst = NULL,
  clip = FALSE,
  bnd = NULL,
  bnd_dsn = NULL,
  tile = TRUE,
  tile_blocksize = 256,
  makestack = FALSE,
  outrastnmlst = NULL,
  outfolder = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{ref_rastfn}{String. Full path name of reference raster.}

\item{rastlst}{String. Full path names of one or more rasters to align.}

\item{resample_methodlst}{String. Resample method ('mode', 'near',
'bilinear', 'cubic', 'cubicspline', 'max', 'min', 'med', 'average'). 
Suggested values: if raster type is categorical; 'mode' or 'near'. 
if raster type is continuous; 'bilinear', 'cubic'.}

\item{clip}{Logical. If TRUE, subset raster to a boundary.}

\item{bnd}{R object or Full path name to a shapefile or layer in a database.}

\item{bnd_dsn}{String. Data source name of bnd, if bnd is a layer in a database.}

\item{tile}{Logical. If TRUE, tile the output raster.}

\item{tile_blocksize}{Numeric. If tile = TRUE, define the size of tile block.}

\item{makestack}{Logical. If TRUE, makes a raster stack with format 'GTIFF'.}

\item{outrastnmlst}{String. Base name of output raster (e.g., 'elev').}

\item{outfolder}{String. Name of folder for writing output raster. If NULL,
outfolder = getwd().}

\item{overwrite}{Logical. If TRUE, overwrite output raster.}
}
\value{
String. List of output raster file names.
}
\description{
Rasters are pixel-aligned and reprojected using the gdal warp function
with help from the gdalraster package. The extent of the reference
raster is used or a given boundary extent.
}
