% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_analysis.R, R/raster_desc.R,
%   R/raster_functions.R
\name{getGDALDataTypeName}
\alias{getGDALDataTypeName}
\alias{getDefaultNodata}
\alias{getOffset}
\alias{getGDALformat}
\alias{getRasterYSize}
\alias{getRasterXSize}
\alias{getRasterCount}
\alias{getGeoTransform}
\alias{getRasterBandInfo}
\alias{basename.NoExt}
\alias{Mode}
\alias{Modes}
\alias{northness}
\alias{eastness}
\alias{roughness}
\alias{TRI}
\alias{TPI}
\alias{getPixelValue}
\alias{.getPixelValue}
\alias{extractPtsFromRaster}
\alias{extractPtsFromRasterList}
\alias{rasterInfo}
\alias{reprojectRaster}
\alias{rasterFromRaster}
\alias{rasterFromVectorExtent}
\alias{rasterizePolygons}
\alias{clipRaster}
\alias{rasterCalc}
\alias{rasterCombine}
\alias{recodeRaster}
\alias{pixelCount}
\alias{focalRaster}
\alias{zonalStats}
\alias{zonalMean}
\alias{zonalFreq}
\alias{zonalMajority}
\alias{zonalMinority}
\alias{zonalVariety}
\alias{ptCsvToVRT}
\alias{raster_desc}
\alias{getrastlst.rgdal}
\alias{areacalc.pixel}
\alias{aspect_transform}
\alias{checkrast.longlat}
\title{Raster Functions}
\usage{
getGDALDataTypeName(GDT_number)

getDefaultNodata(GDT_name)

getOffset(coord, origin, gt_pixel_size)

getGDALformat(file)

getRasterYSize(ds)

getRasterXSize(ds)

getRasterCount(ds)

getGeoTransform(ds)

getRasterBandInfo(ds, b = 1)

basename.NoExt(filepath)

Mode(x, na.rm = FALSE)

Modes(x, na.rm = FALSE)

northness(asp_deg)

eastness(asp_deg)

roughness(x, na.rm = FALSE, asInt = TRUE)

TRI(x, na.rm = FALSE, asInt = TRUE)

TPI(x, na.rm = FALSE, asInt = TRUE)

getPixelValue(
  pt,
  ds,
  ri,
  band = 1,
  interpolate = FALSE,
  windowsize = 1,
  statistic = NULL,
  na.rm = TRUE
)

.getPixelValue(pt, rasterfile, ds, ...)

extractPtsFromRaster(
  ptdata,
  rasterfile,
  band = NULL,
  var.name = NULL,
  interpolate = FALSE,
  windowsize = 1,
  statistic = NULL,
  na.rm = TRUE,
  ncores = 1
)

extractPtsFromRasterList(
  ptdata,
  rasterfiles,
  bands = NULL,
  var.names = NULL,
  interpolate = FALSE,
  windowsizes = NULL,
  statistics = NULL,
  na.rm = TRUE,
  ncores = 1
)

rasterInfo(srcfile)

reprojectRaster(
  srcfile,
  dstfile,
  t_srs,
  overwrite = TRUE,
  s_srs = NULL,
  of = NULL,
  ot = NULL,
  te = NULL,
  tr = NULL,
  r = NULL,
  dstnodata = NULL,
  co = NULL,
  addOptions = NULL
)

rasterFromRaster(
  srcfile,
  dstfile,
  fmt = NULL,
  nbands = NULL,
  dtName = NULL,
  options = NULL,
  init = NULL,
  dstnodata = init
)

rasterFromVectorExtent(
  src,
  dstfile,
  res,
  fmt = NULL,
  nbands = 1,
  dtName = "Int16",
  options = NULL,
  init = NULL,
  dstnodata = init
)

rasterizePolygons(dsn, layer, burn_value, rasterfile, src = NULL)

clipRaster(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  srcfile,
  src_band = NULL,
  dstfile,
  fmt = NULL,
  options = NULL,
  init = 0,
  maskByPolygons = TRUE
)

rasterCalc(
  calc,
  rasterfiles,
  bands = NULL,
  var.names = NULL,
  dstfile = tempfile("rastcalc", fileext = ".img"),
  fmt = NULL,
  dtName = "Int16",
  options = NULL,
  nodata_value = NULL,
  setRasterNodataValue = FALSE,
  usePixelLonLat = FALSE
)

rasterCombine(
  rasterfiles,
  var.names = NULL,
  bands = NULL,
  dstfile = NULL,
  fmt = NULL,
  dtName = "UInt32",
  options = NULL
)

recodeRaster(srcfile, dstfile, lut, srcband = 1, ...)

pixelCount(rasterfile)

focalRaster(
  srcfile,
  dstfile,
  w,
  fun = sum,
  na.rm = FALSE,
  ...,
  fmt = NULL,
  dtName = NULL,
  options = NULL,
  nodata_value = NULL,
  setRasterNodataValue = FALSE,
  srcband = NULL
)

zonalStats(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  attribute,
  rasterfile,
  band = 1,
  lut = NULL,
  pixelfun = NULL,
  na.rm = TRUE,
  ignoreValue = NULL,
  resampling = "nearest"
)

zonalMean(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  attribute,
  rasterfile,
  band = 1,
  lut = NULL,
  pixelfun = NULL,
  na.rm = TRUE,
  ...
)

zonalFreq(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  attribute,
  rasterfile,
  band = 1,
  aggfun = NULL,
  lut = NULL,
  na.rm = FALSE,
  ignoreValue = NULL
)

zonalMajority(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  attribute,
  rasterfile,
  band = 1,
  lut = NULL,
  ...
)

zonalMinority(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  attribute,
  rasterfile,
  band = 1,
  lut = NULL,
  ...
)

zonalVariety(
  dsn = NULL,
  layer = NULL,
  src = NULL,
  attribute,
  rasterfile,
  band = 1,
  lut = NULL,
  ...
)

ptCsvToVRT(csvfile, layer_srs, xfield = "Lon", yfield = "Lat", readvrt = TRUE)

getrastlst.rgdal(
  rastnmlst,
  rastfolder = NULL,
  stopifLonLat = FALSE,
  stopifnull = FALSE,
  gui = TRUE,
  quiet = FALSE
)

areacalc.pixel(rastfn, unit = "ACRES", rast.NODATA = NULL, na.rm = TRUE)

aspect_transform(df, asp)

checkrast.longlat(rastfn, dstfile = NULL, nolonglat = TRUE, crs.default = NULL)
}
\value{
Spatial data object from `sf`. Used for spatial data analyses.
}
\description{
These functions allow for analysis of raster data. Many are written in C++ to
be extremely efficient and fast. Some are wrappers around these C++ functions
for easier use and integration into other packages.
}
\details{
These functions carry out raster data analysis.
}
\author{
Chris Toney, Tracey S. Frescino
}
\keyword{internal}
