% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcheck.functions.R, R/pcheck_desc.R
\name{pcheck.logical}
\alias{pcheck.logical}
\alias{pcheck.unique}
\alias{pcheck.varchar}
\alias{pcheck.dsn}
\alias{pcheck.table}
\alias{pcheck.outfolder}
\alias{pcheck.states}
\alias{pcheck.object}
\alias{pcheck.output}
\alias{pcheck.colors}
\alias{pcheck.areaunits}
\alias{pcheck.spatial}
\alias{pcheck.params}
\alias{pcheck_desc}
\title{Parameter Check Functions}
\usage{
pcheck.logical(
  var2check,
  varnm = NULL,
  title = NULL,
  first = "YES",
  gui = FALSE,
  stopifnull = FALSE
)

pcheck.unique(
  tab,
  uniqueid,
  gui = FALSE,
  tabnm = NULL,
  warn = NULL,
  stopifnull = FALSE,
  stopifinvalid = TRUE,
  multiple = FALSE,
  ...
)

pcheck.varchar(
  var2check,
  varnm = NULL,
  checklst,
  gui = FALSE,
  caption = NULL,
  warn = NULL,
  stopifnull = FALSE,
  stopifinvalid = TRUE,
  multiple = FALSE,
  ...
)

pcheck.dsn(dsn, dbconnopen = TRUE)

pcheck.table(
  tab = NULL,
  conn = NULL,
  tab_dsn = NULL,
  tabnm = NULL,
  tabqry = NULL,
  caption = NULL,
  returnsf = TRUE,
  factors = FALSE,
  returnDT = TRUE,
  warn = NULL,
  stopifnull = FALSE,
  stopifinvalid = FALSE,
  nullcheck = FALSE,
  obj = FALSE,
  gui = FALSE
)

pcheck.outfolder(outfolder, default = getwd(), gui = FALSE)

pcheck.states(
  states,
  statereturn = "MEANING",
  gui = FALSE,
  RS = NULL,
  stopifnull = FALSE,
  ...
)

pcheck.object(
  obj = NULL,
  objnm = NULL,
  warn = NULL,
  caption = NULL,
  stopifnull = FALSE,
  gui = FALSE,
  list.items = NULL
)

pcheck.output(
  out_fmt = "csv",
  out_dsn = NULL,
  outfolder = NULL,
  outfn.pre = NULL,
  outfn.date = FALSE,
  overwrite_dsn = FALSE,
  overwrite_layer = TRUE,
  add_layer = TRUE,
  append_layer = FALSE,
  createSQLite = TRUE,
  out_conn = NULL,
  dbconnopen = FALSE,
  gui = FALSE
)

pcheck.colors(colorlst, n)

pcheck.areaunits(unitarea, areavar, areaunits, metric = FALSE)

pcheck.spatial(
  layer = NULL,
  dsn = NULL,
  sql = NA,
  fmt = NULL,
  tabnm = NULL,
  caption = NULL,
  stopifnull = FALSE,
  gui = FALSE,
  polyfix = FALSE,
  dropgeom = FALSE,
  stopifnoCRS = TRUE,
  checkonly = FALSE
)

pcheck.params(
  input.params,
  strata_opts = NULL,
  unit_opts = NULL,
  table_opts = NULL,
  title_opts = NULL,
  savedata_opts = NULL,
  multest_opts = NULL,
  spMakeSpatial_opts = NULL,
  eval_opts = NULL,
  xy_opts = NULL
)
}
\value{
List of parameter objects checked by the function. While the `pcheck.*()`
functions do return a value, they are primarily used for their side effects
when checking input function parameters.
}
\description{
These functions are used to check parameter inputs.
}
\details{
These functions are used to check parameter inputs.
}
\author{
Tracey S. Frescino
}
\keyword{internal}
