% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fks.R
\name{plot.fks}
\alias{plot.fks}
\title{Plotting fks objects}
\usage{
\method{plot}{fks}(x, CI = 0.95, ahatt.idx = 1:nrow(x$ahatt), ...)
}
\arguments{
\item{x}{The output of \code{\link{fks}}.}

\item{CI}{The confidence interval in case \code{type == "state"}. Set
\code{CI} to \code{NA} if no confidence interval shall be plotted.}

\item{ahatt.idx}{An vector giving the indexes of the predicted state variables
which shall be plotted if \code{type == "state"}.}

\item{\dots}{Arguments passed to either \code{\link{plot}},
\code{\link{qqnorm}}, \code{\link{qqplot}} or \code{\link{acf}}.}
}
\description{
Plotting method for objects of class \code{\link{fks}}. This function
provides tools visualisation of the state vector of the Kalman smoother output
}
\details{
The state variables are plotted. By the argument \code{ahatt.idx}, the user can specify
which of the smoothed (\eqn{a_{t|n}}{a(t|n)}) state variables will be drawn.
}
\examples{
## <--------------------------------------------------------------------------->
## Example 3: Local level model for the treering data
## <--------------------------------------------------------------------------->
## Transition equation:
## alpha[t+1] = alpha[t] + eta[t], eta[t] ~ N(0, HHt)          
## Measurement equation:
## y[t] = alpha[t] + eps[t], eps[t] ~  N(0, GGt)

y <- treering
y[c(3, 10)] <- NA  # NA values can be handled

## Set constant parameters:
dt <- ct <- matrix(0)
Zt <- Tt <- array(1,c(1,1,1))
a0 <- y[1]            # Estimation of the first width
P0 <- matrix(100)     # Variance of 'a0'

## Estimate parameters:
fit.fkf <- optim(c(HHt = var(y, na.rm = TRUE) * .5,
                   GGt = var(y, na.rm = TRUE) * .5),
                 fn = function(par, ...)
                 -fkf(HHt = array(par[1],c(1,1,1)), GGt = array(par[2],c(1,1,1)), ...)$logLik,
                 yt = rbind(y), a0 = a0, P0 = P0, dt = dt, ct = ct,
                 Zt = Zt, Tt = Tt)

## Filter tree ring data with estimated parameters:
fkf.obj <- fkf(a0, P0, dt, ct, Tt, Zt, HHt = array(fit.fkf$par[1],c(1,1,1)),
               GGt = array(fit.fkf$par[2],c(1,1,1)), yt = rbind(y))

fks.obj <- fks(fkf.obj)
plot(fks.obj)
lines(as.numeric(y),col="blue")


}
\seealso{
\code{\link{fks}}
}
\keyword{plot}
