% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basisfns.R
\name{sp_to_ST_basis}
\alias{sp_to_ST_basis}
\title{Add the time coordinate to 2D spatial basis functions}
\usage{
sp_to_ST_basis(G_spatial, t_knots = 1, manifold = STsphere())
}
\arguments{
\item{G_spatial}{an object of class Basis on a 2D manifold}

\item{t_knots}{a vector of numbers locating the knots in time}

\item{manifold}{a 3D space-time manifold, typically \code{STsphere()} or \code{STplane()}}
}
\description{
Given a set of 2D spatial basis functions and a vector of knots in time, this function repeats the spatial basis at every temporal knot, adding the third dimension (i.e., time) to the centroid as appropriate.
}
\examples{
G_spatial <-  local_basis(manifold = sphere(),
                   loc=matrix(runif(20,min=-90,max=90),10,2),
                   scale=rep(20,10),
                   type="bisquare")
G_space_time <- sp_to_ST_basis(G_spatial,1:10,manifold=STsphere())
# library(ggplot2)
# show_basis(G_space_time)
}
