context("Confidence Interval functions OUTPUT")

test_that("binCI() output types",{
  res <- binCI(7,10)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),3)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Wilson","Asymptotic"))
  res <- binCI(c(3,7),10,type="wilson")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="exact")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="asymptotic")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)  
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  
  res <- binCI(7,10,verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),3)
  expect_equal(ncol(res),5)
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Wilson","Asymptotic"))
  res <- binCI(c(3,7),10,type="wilson",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),5)  
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="exact",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),5)  
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
  res <- binCI(c(3,7),10,type="asymptotic",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),5)  
  expect_equal(colnames(res),c("x","n","proportion","95% LCI","95% UCI"))
})

test_that("hyperCI() output types",{
  res <- hyperCI(20,20,10)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
})

test_that("poiCI() output types",{
  res <- poiCI(10)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),4)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly","Byar","Asymptotic"))
  res <- poiCI(10,type="exact")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type="daly")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type="byar")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type="asymptotic")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10,type=c("exact","daly"))
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly"))
  res <- poiCI(10,type="exact",verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),1)
  expect_equal(ncol(res),3)
  expect_equal(colnames(res),c("x","95% LCI","95% UCI"))
  expect_equal(rownames(res),"Exact")
  res <- poiCI(10,type=c("exact","daly"),verbose=TRUE)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),3)
  expect_equal(colnames(res),c("x","95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly"))
  
  res <- poiCI(10:11,type="exact")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10:11,type="daly")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10:11,type="byar")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  res <- poiCI(10:11,type="asymptotic")
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),2)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))

  res <- poiCI(0)
  expect_is(res,"matrix")
  expect_true(is.numeric(res))
  expect_equal(nrow(res),4)
  expect_equal(ncol(res),2)
  expect_equal(colnames(res),c("95% LCI","95% UCI"))
  expect_equal(rownames(res),c("Exact","Daly","Byar","Asymptotic"))
})

