% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ED.R
\name{compute.ed}
\alias{compute.ed}
\title{Euclidean distance (ED)}
\usage{
compute.ed(Y, X)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}
}
\description{
Compute the Euclidean distance between two vectors having the same length Y and X.
}
\details{
This function returns the  Euclidean distance of two vectors corresponding to univariate signals.
A lower ED (\eqn{ED \in [0, \inf]}) value indicates that the two vectors are more similar.
The both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In two input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[, 1] ; Y <- dataFSMUMI[, 2]
compute.ed(Y,X)
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
