% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCC.R
\name{LCC}
\alias{LCC}
\title{Linear Consistency-Constrained algorithm}
\usage{
LCC(data, class, featureSetEval, featureEval = symmetricalUncertain,
  threshold = 0.9)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate feature sets
}}

\item{featureEval}{\itemize{
\item The measure for evaluate individual features
}}

\item{threshold}{\itemize{
\item Threshold
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
}
}
\description{
Linear Consistency-Constrained algorithm described in \insertCite{ShinXu2009}{FSinR}.
}
\examples{
## sfbs method for iris dataset (filter method)
LCC(iris, 'Species', IEConsistency)
}
\references{
\insertAllCited{}
}
\author{
Alfonso Jiménez-Vílchez
}
