% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.R
\name{giniIndex}
\alias{giniIndex}
\title{Gini index measure}
\usage{
giniIndex()
}
\value{
Returns a function that is used to generate an evaluation set measure using the Gini index value for the selected features.
}
\description{
Generates an evaluation function that calculates the gini index \insertCite{Ceriani2012}{FSinR} of discrete features (set measure). This function is called internally within the \code{\link{filterEvaluator}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly to evaluate a set of features
## Classification problem

# A discrete dataset is used (in this case we use only several discrete columns)
adult <- adult[,c(4,9,10,15)]

# Generate the evaluation function with Gini index
giniIndex_evaluator <- giniIndex()
# Evaluate the features (parameters: dataset, target variable and features)
giniIndex_evaluator(adult,'income',c('race','sex','education'))
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez
}
