\name{penplot}
\alias{penplot}
\title{
Plot penetrance functions
}
\description{
Plots the penetrance functions given the baseline parameter and regression coefficients' values and choices of baseline and frailty distributions.
}
\usage{
penplot(base.parms, vbeta, variation="none", base.dist="Weibull", 
       frailty.dist=NULL, depend=1, agemin=20, print=TRUE, ...)
}
\arguments{
  \item{base.parms}{
Vector of parameter values for baseline hazard function. 

\code{base.parms=c(lambda, rho)}, where lambda and rho are the shape and scale parameters, respectively.
}
 \item{vbeta}{
 Vector of regression coefficients for gender and majorgene
 
 \code{vbeta=c(beta.s, beta.g)}. If \code{variation="secondgene"}, specify regression coefficient for second gene in \code{vbeta=c(beta.s, beta.g1, beta.g2)}.
 
}
 \item{base.dist}{
Choice of baseline hazard distribution. Possible choices are: \code{"Weibull"}, \code{"loglogistic"}, \code{"Gompertz"}, \code{"lognormal"}, or \code{"gamma"}. Default is \code{"Weibull"}.
}

 \item{frailty.dist}{
Choice of frailty distribution. Possible choices are \code{"gamma"} for gamma distribution or \code{"lognormal"} for log normal distributions when \code{variation="frailty"}. Default is \code{NULL}.
}

  \item{variation}{
Source of residual familial correlation. Possible choices are \code{"frailty"} for frailty shared within families, \code{"secondgene"} for second gene shared within families, or \code{"none"} for no residual familial correlation.  Default is \code{"none"}
}

  \item{depend}{
Variance of the frailty distribution. Dependence within families increases with \code{depend} value.  Default value is 1. 
}
\item{agemin}{
	Minimum age of disease onset. Default is 20 years of age.
}
\item{print}{
	Logical; if TRUE, prints the penetrance values by age 70 from the assumed model.
}
\item{...}{
	Other parameters to be passed through to plotting functions.}
}
\details{
%At the moment the function will only generate penetrance curves for the gamma frailty model and the second gene model. The penetrance curves for the log-normal frailty will be implemented at a later date.
The penetrance model conditional on the frailty \eqn{Z} and covariates \eqn{X=(x_s, x_g)} is assumed to have the following hazard function
\deqn{ h(t|X,Z) = h_0(t-t_0) Z \exp(\beta_s x_s+\beta_g x_g),}
where \eqn{h_0(t)} is the baseline hazard function, \eqn{t_0} is a minimum age of disease onset, \eqn{x_s} and \eqn{x_g} indicate male (1) or female (0) and carrier (1) or non-carrier (0) of a main gene of interest, respectively.

For example, when using a Weibull distribution for baseline hazard and a gamma distribution for frailty, the penetrance function has the form
\deqn{1-\left\{1+\frac{\lambda^\rho (t-t_0)^\rho \exp(\beta_s x_s+\beta_g x_g)}{\kappa}\right\}^{-\kappa} .}

The penetrance curve for the second gene model is generated by
\deqn{1-\exp\left\{-\lambda^\rho (t-t_0)^\rho \exp (\beta_g x_g+\beta_{g1} x_{g1} + \beta_{g2} x_{g2}) \right\} }
where \eqn{x_{g1}} indicates carrior (1) or non-carrior (0) of a major gene and \eqn{x_{g2}} indicates carrior (1) or non-carrior (0) of a second gene.

When plotting with the second gene model, the plot will generate separate curves for mutation carriers and noncarriers, and seperate curves for the second gene carriers and noncarriers.

}
\value{
Displays plots of the penetrance functions and returns the following values:

\item{pen70}{Penetrance estimates by age 70 specific to gender and mutation-status subgroups. }
\item{x.age}{Vetor of ages of onsest ranging from \code{agemin} to 80 years}
\item{pen}{Lists of penetrance estimates computed at each age of \code{x.age}; if \code{variation = "none"} or \code{"frailty"}, lists include subgroups specific to gender and mutation status for major gene. If \code{variation = "secondgene"},  lists include subgroups specific to gender and both mutation statuses for major gene and second gene.}
}

\author{
Yun-Hee Choi
}
\seealso{
\code{\link{simfam}, \link{plot.penmodel}}
}
\examples{
# Penetrance function curves based on Weibull baseline hazard function

penplot(base.parms=c(0.01,3), vbeta=c(0.5, 2), base.dist="Weibull", agemin=20)

}
\keyword{Penetrance plot}
