% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{dptTraj}
\alias{dptTraj}
\title{Inferenence of diffusion pseudotime (DPT) for all cells on a differentiation trajectory}
\usage{
dptTraj(x, y, fb, trthr = NULL, distance = "euclidean", sigma = 1000, ...)
}
\arguments{
\item{x}{expression data frame with genes as rows and cells as columns. Gene IDs should be given as row names and cell IDs should be given as column names. This can be a reduced expression table only including the features (genes) to be used in the analysis.}

\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of x.}

\item{fb}{fateBias object returned by the function \code{fateBias}.}

\item{trthr}{real value representing the threshold of the fraction of random forest votes required for the inclusion of a given cell for the derivation of the diffusion pseudotime. If \code{NULL} then only cells with a signifcant fate bias >1 are included for each trajectory. Default value is \code{NULL}.}

\item{distance}{parameter for the computation of the underlying diffusion map computed by the function \code{DiffusionMap} from the \pkg{destiny} package. Default value is \code{euclidean}.}

\item{sigma}{parameter for the computation of the underlying diffusion map computed by the function \code{DiffusionMap} from the \pkg{destiny} package. Default value is 1000.}

\item{...}{additional arguments to be passed to the low level function \code{DiffusionMap}.}
}
\value{
trc A list of ordered cell IDs for each trajectory giving rise to one of the targer clusters in \code{fb}
}
\description{
This function computes a pseudo-temporal ordering of cells reflecting the differentiation projects by using the \code{DPT} function from the \code{destiny} package.
}
\details{
The function orders all cells assigned to a differentiation trajectory with a significant fate bias >1 or a probability greater \code{trthr} for a trajectory, respectively, by diffusion pseudotime.
}
\examples{

\donttest{
x <- intestine$x
y <- intestine$y
tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
dr <- compdr(x,z=NULL,m="cmd",k=2,lle.n=30,dm.sigma=1000,dm.distance="euclidean",tsne.perplexity=30)
trc <- dptTraj(x,y,fb,trthr=.25,distance="euclidean",sigma=1000)
}
}
