% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GHCN_FUNCTIONS.R
\name{getGHCNDailyStation}
\alias{getGHCNDailyStation}
\title{Download and extract the daily data for a GHCN weather station.}
\usage{
getGHCNDailyStation(ID, elements = NULL, raw.dir, standardize = F,
  force.redo = F)
}
\arguments{
\item{ID}{A character string giving the station ID.}

\item{elements}{A character vector of elemets to extract.
Common elements include "tmin", "tmax", and "prcp".}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.}

\item{standardize}{Select only common year/month/day? Defaults to FALSE.}

\item{force.redo}{If this weather station has been downloaded before, should it be updated? Defaults to FALSE.}
}
\value{
A named list of \code{\link{data.frame}s}, one for each \code{elements}.
}
\description{
\code{getGHCNDailyStation} returns a named list of \code{\link{data.frame}s}, one for
each \code{elements}. If \code{elements} is undefined, it returns all available weather
tables for the station
}

