% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NHD_FUNCTIONS.R
\name{get_nhd_subregion}
\alias{get_nhd_subregion}
\title{Download and crop data from a zipped HUC4 subregion
of the National Hydrography Dataset.}
\usage{
get_nhd_subregion(template = NULL, area, res, raw.dir)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve 
as a template for cropping.}

\item{area}{A 4-character string indicating the HUC4 NHD subregion to download and crop.}

\item{res}{A character string defining the resolution of the NHD to download.
Either "medium" (the default), or "high".}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing.}
}
\value{
A \code{SpatialPolygonsDataFrame} of the HUC4 regions within
the specified \code{template}.
}
\description{
\code{get_nhd_subregion} returns a list of \code{SpatialPolygonsDataFrame}s of the layers of the HUC4 subregion,
 within the specified \code{template}. If template is not provided, returns the entire HUC4 subregion.
}
\keyword{internal}

