% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLCD_FUNCTIONS.R
\name{get_nlcd}
\alias{get_nlcd}
\alias{nlcd_colors}
\alias{pal_nlcd}
\title{Download and crop the National Land Cover Database.}
\usage{
get_nlcd(
  template,
  label,
  year = 2021,
  dataset = "landcover",
  landmass = "L48",
  extraction.dir = file.path(tempdir(), "FedData", "extractions", "nlcd", label),
  raster.options = c("COMPRESS=DEFLATE", "ZLEVEL=9"),
  force.redo = FALSE
)

nlcd_colors()

pal_nlcd()
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{terra}} object to serve as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{year}{An integer representing the year of desired NLCD product.
Acceptable values are 2021 (default), 2019, 2016, 2011, 2008, 2006, 2004, and 2001.}

\item{dataset}{A character string representing type of the NLCD product.
Acceptable values are 'landcover' (default), 'impervious', and
'canopy'.}

\item{landmass}{A character string representing the landmass to be extracted
Acceptable values are 'L48' (lower 48 US states, the default),
'AK' (Alaska, 2011 and 2016 only), 'HI' (Hawaii, 2001 only), and
'PR' (Puerto Rico, 2001 only).}

\item{extraction.dir}{A character string indicating where the extracted
and cropped NLCD data should be put. The directory will be created if missing.}

\item{raster.options}{a vector of GDAL options passed to \link[terra:writeRaster]{terra::writeRaster}.}

\item{force.redo}{If an extraction for this template and label already exists,
should a new one be created?}
}
\value{
A \code{RasterLayer} cropped to the bounding box of the template.
}
\description{
\code{get_nlcd} returns a \code{\link[terra:SpatRaster-class]{SpatRaster}} of NLCD data cropped to a given
template study area. \code{nlcd_colors} and \code{pal_nlcd} return the NLCD
legend and color palette, as available through the
\href{https://www.mrlc.gov/data/legends/national-land-cover-database-class-legend-and-description}{MLRC website}.
}
\examples{
\dontrun{
# Extract data for the Mesa Verde National Park:

# Get the NLCD (USA ONLY)
# Returns a raster
NLCD <-
  get_nlcd(
    template = FedData::meve,
    label = "meve",
    year = 2016
  )

# Plot with terra::plot
plot(NLCD)
}
}
