% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compound_symmetry_gxe.R
\name{compsym_asr_output}
\alias{compsym_asr_output}
\title{Simulate genetic values based on a compound symmetry model for GxE interaction -
Simulation using 'AlphaSimR'}
\usage{
compsym_asr_output(pop, n_envs, n_traits, n_reps, effects = FALSE)
}
\arguments{
\item{pop}{An \href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} population object
(\href{https://gaynorr.github.io/AlphaSimR/reference/Pop-class.html}{Pop-class} or
\href{https://gaynorr.github.io/AlphaSimR/reference/HybridPop-class.html}{HybridPop-class})
generated using \link[FieldSimR]{compsym_asr_input}.}

\item{n_envs}{Number of simulated environments (same number used in
\link[FieldSimR]{compsym_asr_input}).}

\item{n_traits}{Number of simulated traits (same number used in \link[FieldSimR]{compsym_asr_input}).}

\item{n_reps}{A vector defining the number of replicates in each environment. If only one value
is specified, all environments will be assigned the same number.}

\item{effects}{When \code{TRUE}, a list is returned with additional entries containing the total
(additive + dominance + epistatic) main effects and GxE interaction effects for each
environment-within-trait combination. By default, \code{effects = FALSE}.}
}
\value{
A data frame with columns 'env', 'rep', genotype 'id', and the
  simulated genetic values for each trait. When \code{effects = TRUE}, a list is returned with
  additional entries containing the total (additive + dominance + epistatic) main effects and
  GxE interaction effects for each environment-within-trait combination.
}
\description{
Creates a data frame of simulated genetic values for multiple traits across multiple environments
based on a compound symmetry model for genotype-by-environment (GxE) interaction. This function
requires an \href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} population object
generated using the function \link[FieldSimR]{compsym_asr_input}.
}
\examples{
# Simulate genetic values in 'AlphaSimR' for two additive + dominance traits across
# two environments based on a compound symmetry model for GxE interaction.

# 1. Define the genetic architecture of the simulated traits.
# Mean genetic values and mean dominance degrees.
mean <- c(4.9, 5.4, 235.2, 228.5) # Trait 1 x 2 environments, trait 2 x 2 environments.
mean_DD <- c(0.4, 0.4, 0.1, 0.1) # Trait 1 and 2, same values in the two environments.

# Additive genetic variances and dominance degree variances.
var <- c(0.08, 13) # Different values set for traits 1 and 2.
var_DD <- c(0.2, 0.2) # The same value set for traits 1 and 2.

# Relative magnitude of the additive and dominance degree main effect variances.
rel_main_eff_A <- c(0.4, 0.6) # Different values set for traits 1 and 2.
rel_main_eff_DD <- 0.4 # The same value set for traits 1 and 2.

# Additive and dominance degree correlations between the two simulated traits.
cor_A <- matrix( # Additive correlation matrix.
  c(
    1.0, 0.5,
    0.5, 1.0
  ),
  ncol = 2
)
cor_DD <- diag(2) # Dominance correlation matrix - assume independence.

input_asr <- compsym_asr_input(
  n_envs = 2,
  n_traits = 2,
  mean = mean,
  var = var,
  rel_main_eff_A = rel_main_eff_A,
  cor_A = cor_A,
  mean_DD = mean_DD,
  var_DD = var_DD,
  rel_main_eff_DD = rel_main_eff_DD,
  cor_DD = cor_DD
)


# 2. Use input_asr to simulate genetic values in 'AlphaSimR' based on a compound symmetry model
# for GxE interaction.

library("AlphaSimR")
FOUNDERPOP <- quickHaplo(
  nInd = 10,
  nChr = 1,
  segSites = 20
)

SP <- SimParam$new(FOUNDERPOP)

\dontshow{
SP$nThreads <- 1L
}

SP$addTraitAD(
  nQtlPerChr = 20,
  mean = input_asr$mean,
  var = input_asr$var,
  meanDD = input_asr$mean_DD,
  varDD = input_asr$var_DD,
  corA = input_asr$cor_A,
  corDD = input_asr$cor_DD,
  useVarA = TRUE
)

# By default, the value provided in 'var' represents the additive variance.
# If useVarA = FALSE, 'var' represents the total genetic variance.

pop <- newPop(FOUNDERPOP)


# 3. Create a data frame containing the simulated genetic values for the two traits across the
# two environments.

n_reps <- c(2, 2) # Vector containing the number of complete replicates in each environment.

gv_df <- compsym_asr_output(
  pop = pop,
  n_envs = 2,
  n_traits = 2,
  n_reps = n_reps,
  effects = TRUE
)
}
