% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.CausalANOVA.R
\name{test.CausalANOVA}
\alias{test.CausalANOVA}
\title{Estimating the AMEs and AMIEs after Regularization with the CausalANOVA.}
\usage{
test.CausalANOVA(fit, newdata, collapse.level = TRUE, diff = FALSE,
  pair.id = NULL, cluster = NULL)
}
\arguments{
\item{fit}{The output from \code{CausalANOAV} function.}

\item{newdata}{A data frame to use for re-estimating the AMEs and AMIEs with
confidence intervals.}

\item{collapse.level}{A logical indicating whether to collapse insignificant
levels within factors as suggested by the \code{CausalANOVA} output users
provide.}

\item{diff}{A logical indicating whether the outcome is the choice between a
pair. If \code{diff=TRUE}, \code{pair.id} should specify a pair of
comparison. Default is \code{FALSE}.}

\item{pair.id}{(optional).Unique identifiers for each pair of comparison.
This option is used when \code{diff=TRUE}.}

\item{cluster}{Unique identifies with which cluster standard errors are
computed.}
}
\value{
\item{fit}{The output of class \code{CausalANOVA}.}
}
\description{
\code{test.CausalANOVA} estimates the AMEs and AMIEs with confidence
intervals after regularization with \code{CausalANOVA}function.
}
\details{
See Details in \code{CausalANOVA}.
}
\references{
Egami, Naoki and Kosuke Imai. 2016+. ``Causal Interaction in
Factorial Experiments: Application to Conjoint Analysis.'' Working paper.
\url{http://imai.princeton.edu/research/files/int.pdf}

Lim, M. and Hastie, T. 2015. Learning interactions via hierarchical
group-lasso regularization. Journal of Computational and Graphical
Statistics 24, 3, 627--654.

Post, J. B. and Bondell, H. D. 2013. ``Factor selection and structural
identification in the interaction anova model.'' Biometrics 69, 1, 70--79.
}
\examples{
## ####################################### 
## With Screening and Collapsing
## #######################################
data(Carlson)
## Specify the order of each factor
Carlson$newRecordF<- factor(Carlson$newRecordF,ordered=TRUE,
                            levels=c("YesLC", "YesDis","YesMP",
                            "noLC","noDis","noMP","noBusi"))
Carlson$promise <- factor(Carlson$promise,ordered=TRUE,levels=c("jobs","clinic","education"))
Carlson$coeth_voting <- factor(Carlson$coeth_voting,ordered=FALSE,levels=c("0","1"))
Carlson$relevantdegree <- factor(Carlson$relevantdegree,ordered=FALSE,levels=c("0","1"))
########## Sample Splitting ##########
train.ind <- sample(unique(Carlson$respcodeS), 272, replace=FALSE)
test.ind <- setdiff(unique(Carlson$respcodeS), train.ind)
Carlson.train <- Carlson[is.element(Carlson$respcodeS,train.ind), ]
Carlson.test <- Carlson[is.element(Carlson$respcodeS,test.ind), ]

#################### AMEs and two-way AMIEs ####################
fit.r2 <- CausalANOVA(formula=won ~ newRecordF + promise + coeth_voting + relevantdegree,
                      data=Carlson.train, pair.id=Carlson.train$contestresp,diff=TRUE,
                      screen=TRUE, collapse=TRUE,
                      cluster=Carlson.train$respcodeS, nway=2)
summary(fit.r2)

## refit with test.CausalANOVA
fit.r2.new <- test.CausalANOVA(fit.r2, newdata=Carlson.test, diff=TRUE,
                               pair.id=Carlson.test$contestresp, cluster=Carlson.test$respcodeS)

summary(fit.r2.new)
plot(fit.r2.new)
plot(fit.r2.new, type="ConditionalEffect", fac.name=c("newRecordF","coeth_voting"))
ConditionalEffect(fit.r2.new, treat.fac="newRecordF", cond.fac="coeth_voting")
}
\seealso{
\link{CausalANOVA}.
}
\author{
Naoki Egami and Kosuke Imai.
}
