% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.info.R
\name{input.info}
\alias{input.info}
\title{Input the Information about Individuals and Chambers}
\usage{
input.info(ID = c(NA, NA, NA, NA, NA, NA, NA, NA),
           Weight = c(NA, NA, NA, NA, NA, NA, NA, NA),
           Volume = c(NA, NA, NA, NA, NA, NA, NA, NA),
           DO.unit = c("mg/L", "mmol/L", "ml/L"))
}
\arguments{
\item{ID}{string: ID of fish or another aquatic organism}

\item{Weight}{numeric: wet weight of an individual in grams (g)}

\item{Volume}{numeric: the volume of chambers in milliliters (mL)}

\item{DO.unit}{character: dissolved oxygen unit used in raw data}
}
\value{
The function returns a data frame with four columns: "ID", "Weight", "Volume", "DO.unit". The data frame is used in the functions \code{\link{import.test}}, \code{\link{import.meas}}, and \code{\link{correct.meas}}.
}
\description{
The function is used to input manually the information required for metabolic rate calculations: ID and wet weight of individuals, volume of chambers. Values of those parameters should be filled in the same order in a vector format replacing default NA values in the template. In addition, specify which unit has been used to measure dissolved oxygen concentration.
}
\details{
It is especially important to keep such format of vectors when not the full number of individuals is in a multi-channel respirometry system. E.g.: if you use a 4-channel respirometry system with three fish and only Chamber 1 is empty, but data are still collected from there, do not remove NA values for that chamber to prevent the shift of actual data between the chambers.\cr If DO unit is different than "mg/L", "mmol/L" or "ml/L", please use the function \code{\link{convert.rMR}} or \code{\link{convert.respirometry}} to convert the unit to "mg/L", "mmol/L" or "ml/L".
}
\examples{
# Four sticklebacks in a 4-channel respirometry system
info <- input.info(ID = c("Stickleback_1", "Stickleback_2",
                          "Stickleback_3", "Stickleback_4"),
                   Weight = c(1.86, 1.92, 2.23, 1.80),
                   Volume = c(250, 250, 250, 250),
                   DO.unit = "mg/L")

}
