% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rVIB}
\alias{rVIB}
\title{Random generation from the variance-inflated beta distribution}
\usage{
rVIB(n, mu, phi, p, k, q0 = NULL, q1 = NULL)
}
\arguments{
\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mu}{the mean parameter of the variance-inflated distribution. It must lie in (0, 1).}

\item{phi}{the precision parameter of the variance-inflated distribution. It must be a positive real value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{k}{the extent of the variance inflation. It must lie in (0, 1).}

\item{q0}{the probability of augmentation in zero. It must lie in (0, 1). In case of no augmentation is \code{NULL} (default).}

\item{q1}{the probability of augmentation in one. It must lie in (0, 1). In case of no augmentation is \code{NULL} (default).}
}
\value{
A vector of length  \code{n}.
}
\description{
The function generates random values from the variance-inflated beta distribution, or from the augmented variance-inflated beta distribution.
}
\examples{
rVIB(n = 100, mu = .5, phi = 30, p = .3, k = .6)
rVIB(n = 100, mu = .5, phi = 30, p = .3, k = .6, q0 = .2, q1 = .1)

}
\references{
{
 Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020). Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309. doi:10.1177/1471082X18821213
}
}
