% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{package}
\name{ForIT-package}
\alias{ForIT}
\alias{ForIT-package}
\title{Functions for Italian Tree species Volume and Biomass}
\description{
The ForIT package is the implementation of the biomass and volume models
carried out by Gasparini and Tabacchi (2011) and Tabacchi et al. (2011a)
during the 2nd Italian National Forest Inventory. An English description of
the methodology is provided by Tabacchi et al. (2011b). This package is
intended as the close translation in R of the literature cited above.
}
\details{
\tabular{ll}{ Package: \tab ForIT\cr Type: \tab Package\cr Version: \tab
1.0\cr Date: \tab 2014-07-04\cr License: \tab What license is it under?\cr
}
}
\examples{
# one single tree
INFCvpe('Acca', 22, 14, mod='v', freq=2, aggr=FALSE)

# a list with ten trees of the same specie
INFCvpe(rep('Acca',10),d=c(10,15,20,30,32,24,36,40,8,18),
    h=c(7,9,12,20,21,18,21,22,8,12), mod='v', aggr=TRUE)

# a list of different species
species <- rep(c('Abal','Piab'),2)
dbh <- c(10,41,20,30)
heigths <- c(12,14,13,15)
frequences <- c(2,6,5,4)
data.frame(species, dbh, heigths, frequences)

# single-tree estimates
INFCvpe(species, dbh, heigths, mod='v', frequences, aggr=FALSE)

# estimates aggregated at species level
INFCvpe(species, dbh, heigths, mod='v', frequences, aggr=TRUE)
}
\author{
Nicola Puletti, Marco Mura, Cristiano Castaldi, Maurizio Marchi, Ugo Chiavetta, Roberto Scotti

Maintainer: Nicola Puletti \email{nicola.puletti@gmail.com}
}
\references{
Gasparini, P., Tabacchi, G.(eds), 2011. \emph{L'Inventario
Nazionale delle Foreste e dei serbatoi forestali di Carbonio INFC 2005.
Secondo inventario forestale nazionale italiano. Metodi e risultati}.
Edagricole. 653 pp. [ITA, ita]

Tabacchi G., Di Cosmo L., Gasparini P., Morelli S., 2011a. \emph{Stima del
volume e della fitomassa delle principali specie forestali italiane.
Equazioni di previsione, tavole del volume e tavole della fitomassa arborea
epigea. Stima del volume e della fitomassa delle principali specie
forestali italiane. Equazioni di previsione, tavole del volume e tavole
della fitomassa arborea epigea}. 412 pp. [ITA, ita]

Tabacchi G., Di Cosmo L., Gasparini P., 2011b. \emph{Aboveground tree
volume and phytomass prediction equations for forest species in Italy}.
European Journal of Forest Research 130: 6 911-934 [ENG, eng]
}
\keyword{package}

