% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_d_gnfi3.R
\name{age_d_gnfi3_core}
\alias{age_d_gnfi3_core}
\title{Core Function For the Inverse Stem Diameter Growth Model of the 3rd German
National Forest Inventory (2012)}
\usage{
age_d_gnfi3_core(species_id, dbh_cm, dbh_cm_known, age_yr_known, params)
}
\arguments{
\item{species_id}{Vector of species ids (see \code{\link{age_d_gnfi3}}),
but for this core function to work, \code{species_id} must be provided as
\code{character}. This will and should be not checked inside this function,
because if used as intended, that has happened before calling it. The
codings must either follow the \emph{ger_nfi_2012} or the \emph{tum_wwk_short}
coding. In the former case, the parameter \code{param_orig} must be TRUE,
in the latter, it must be FALSE.}

\item{dbh_cm}{Single numeric value or vector of dbh (cm) for which the
age is to be estimated}

\item{dbh_cm_known}{Vector of known dbh (cm) values at age
\code{age_yr_known}}

\item{age_yr_known}{Vector of ages (years) for which the dbh
\code{d_cm_known} is known}

\item{params}{A data frame that defines the function parameters corresponding
to the species coding represented by \code{species_id}}
}
\value{
A vector with estimates of the trees' expected dbh (see
\code{\link{age_d_gnfi3}})
}
\description{
See documentation of \code{\link{age_d_gnfi3}} for most information,
this function is the workhorse behind, and should never be called directly by
a user.
}
\details{
The function \code{age_d_gnfi3} is fully vectorized, inputs are recyled
according to the tibble rules
}
\keyword{internal}
