% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.taxonomy.R
\name{plot.taxonomy}
\alias{plot.taxonomy}
\title{Plot simulated taxonomy}
\usage{
\method{plot}{taxonomy}(x, tree, show.mode = TRUE, show.legend = TRUE,
  legend.position = "bottomleft", root.edge = TRUE, hide.edge = FALSE,
  edge.width = 1, show.tip.label = FALSE, align.tip.label = FALSE,
  cex = 1.2, ...)
}
\arguments{
\item{x}{Taxonomy object.}

\item{tree}{Phylo object.}

\item{show.mode}{Indicate speciation mode. #TODO}

\item{show.legend}{Add a legend for the symbols indicating different speciation modes.}

\item{legend.position}{Position of the legend. Options include \code{"bottomleft"} (default), \code{"topleft"}, \code{"bottomright"}, \code{"topright"} or a vector of length 2 with x, y coordinates.}

\item{root.edge}{If TRUE include the root edge (default = TRUE).}

\item{hide.edge}{If TRUE hide the root edge but still incorporate it into the automatic timescale (default = FALSE).}

\item{edge.width}{A numeric vector giving the width of the branches of the plotted phylogeny. These are taken to be in the same order as the component edge of \code{tree}. If fewer widths are given than the number of edges, then the values are recycled.}

\item{show.tip.label}{Whether to show the tip labels on the phylogeny (defaults to FALSE).}

\item{align.tip.label}{A logical value or an integer. If TRUE, the tips are aligned and dotted lines are drawn between the tips of the tree and the labels. If an integer, the tips are aligned and this gives the type of the lines (lty).}

\item{cex}{Numeric value giving the factor used to scale the points representing the fossils when \code{show.fossils = TRUE}.}

\item{...}{Additional parameters to be passed to \code{plot.default}.}
}
\description{
This function is adapted from the \emph{ape} function \code{plot.phylo} used to plot phylogenetic trees.
The function can be used to plot simulated taxonomy along with the corresponding tree.
}
\examples{
set.seed(123)

## simulate tree
t = TreeSim::sim.bd.taxa(8, 1, 1, 0.3)[[1]]

## simulate taxonomy
s = sim.taxonomy(t, 0.5, 1)

## plot the output
plot(s, t)

}
