#' Assign zero amplitude to some of the non-zero frequencies of an existing
#' Fourier descriptor generated by
#' \code{\link{random.fourier.descriptor}}
#' 
#' Returns a new Fourier descriptor.
#'
#' @include random-fourier-descriptor.R
#' @param fourier.descriptor A Fourier descriptor object generated by
#'   \code{\link{random.fourier.descriptor}}
#' @param old.frequencies How many frequency components should be removed?
#'   Defaults to 1.
#' @export
#' @examples
#' fourier.descriptor <- random.fourier.descriptor(12)
#'
#' fd <- simplify.fourier.descriptor(fourier.descriptor)
#'
#' fd <- complicate.fourier.descriptor(fourier.descriptor,
#'                                     old.frequencies = 3)
#' @usage
#' fourier.descriptor <- random.fourier.descriptor(12)
#'
#' fd <- simplify.fourier.descriptor(fourier.descriptor)

simplify.fourier.descriptor <- function(fourier.descriptor, quantity = 1)
{
  non.zero.frequencies <- which(fourier.descriptor[['Amplitude']] != 0)
  
  if (length(non.zero.frequencies) < quantity)
  {
    stop('Not enough frequencies have non-zero amplitude to perform simplification.')
  }
  
  if (length(non.zero.frequencies) == 1)
  {
    remove.frequencies <- non.zero.frequencies
  }
  else
  {
    remove.frequencies <- sample(non.zero.frequencies, quantity)
  }
  
  for (frequency in remove.frequencies)
  {
    fourier.descriptor[['Amplitude']][frequency] <- 0
  }
  
  return(fourier.descriptor)
}
