% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-min_max.R
\docType{methods}
\name{minimum}
\alias{minimum}
\alias{minimum,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Minimum of fuzzy nubmers}
\usage{
\S4method{minimum}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)
}
\arguments{
\item{e1}{a PiecewiseLinearFuzzyNumber}

\item{e2}{a PiecewiseLinearFuzzyNumber}
}
\value{
Returns a PiecewiseLinearFuzzyNumber representing maximal
value of the inputs.
}
\description{
Determines minimum fuzzy number based on two inputs.
}
\details{
The resulting 
PiecewiseLinearFuzzyNumber is only an approximation of the result
it might not be very precise for small number of knots (see examples).
}
\examples{
# example with low number of knots, showing the approximate nature
# of the result
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-4.8, -3 , -1.5))
y = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-5.5, -2.5, -1.1))
minFN = minimum(x,y)
min = min(alphacut(x,0)[1],alphacut(y,0)[1])
max = max(alphacut(x,0)[2],alphacut(y,0)[2])
plot(x, col="red", xlim=c(min,max))
plot(y, col="blue", add=TRUE)
plot(minFN, col="green", add=TRUE)

# example with high number of knots, that does not suffer 
# from the approximate nature of the result
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-4.8, -3 , -1.5), knot.n = 9)
y = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-5.5, -2.5, -1.1), knot.n = 9)
minFN = minimum(x,y)
min = min(alphacut(x,0)[1],alphacut(y,0)[1])
max = max(alphacut(x,0)[2],alphacut(y,0)[2])
plot(x, col="red", xlim=c(min,max))
plot(y, col="blue", add=TRUE)
plot(minFN, col="green", add=TRUE)
}
\references{
KAUFMANN, A., GUPTA, M. M. (1985) Introduction to Fuzzy Arithmetic.
New York : Van Nostrand Reinhold Company. ISBN 044230079.
}
\seealso{
Other min_max-operators: \code{\link{maximum}}

Other PiecewiseLinearFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{PiecewiseLinearFuzzyNumber-class}},
  \code{\link{PiecewiseLinearFuzzyNumber}},
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{alphaInterval}}, \code{\link{arctan2}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}},
  \code{\link{expectedInterval}}, \code{\link{fapply}},
  \code{\link{maximum}}, \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{plot}}, \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityUndervaluation}}
}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{min_max-operators}
