% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-value.R
\docType{methods}
\name{value}
\alias{value}
\alias{value,FuzzyNumber-method}
\title{Calculate the Value of a Fuzzy Number}
\usage{
\S4method{value}{FuzzyNumber}(object, ...)
}
\arguments{
\item{object}{a fuzzy number}

\item{...}{additional arguments passed to \code{\link{alphaInterval}}}
}
\value{
Returns a single numeric value.
}
\description{
The calculation of the so-called value is one of possible methods to
deffuzify a fuzzy number.
}
\details{
The value of \eqn{A} (Delgrado et al, 1998) is defined as
\eqn{val(A) := \int_0^1 \alpha\left(A_L(\alpha)+A_U(\alpha)\right)\,d\alpha}{val(A) := int_0^1 \alpha(A_L(\alpha) + A_U(\alpha))d\alpha}.
}
\references{
Delgado M., Vila M.A., Voxman W. (1998), On a canonical representation of a fuzzy number,
Fuzzy Sets and Systems 93, pp. 125-135.
}
\seealso{
Other FuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{FuzzyNumber-class}},
  \code{\link{FuzzyNumber}}, \code{\link{alphaInterval}},
  \code{\link{alphacut}}, \code{\link{ambiguity}},
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}}, \code{\link{core}},
  \code{\link{distance}}, \code{\link{evaluate}},
  \code{\link{expectedInterval}},
  \code{\link{expectedValue}},
  \code{\link{integrateAlpha}},
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{plot}}, \code{\link{show}},
  \code{\link{supp}},
  \code{\link{trapezoidalApproximation}},
  \code{\link{weightedExpectedValue}}, \code{\link{width}}

Other deffuzification: \code{\link{expectedValue}},
  \code{\link{weightedExpectedValue}}

Other characteristics: \code{\link{ambiguity}},
  \code{\link{expectedValue}},
  \code{\link{weightedExpectedValue}}, \code{\link{width}}
}
\concept{FuzzyNumber-method}
\concept{characteristics}
\concept{deffuzification}
