% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omni_individual.R
\name{OMNI_individual}
\alias{OMNI_individual}
\title{omni_individual.R}
\usage{
OMNI_individual(null_model, factor_matrix, link_function, num_boots = 100)
}
\arguments{
\item{null_model}{An R regression model fitted using glm().  Do not use lm(), even for linear regression!}

\item{factor_matrix}{An n*d matrix with each factor (i.e. each SNP) as one column.  There should be no missing data.}

\item{link_function}{Either "linear" or "logit" or "log".}

\item{num_boots}{Number of bootstrap repetitions to find correlation matrix of set-based statistics.}
}
\value{
A list with the elements:
\item{OMNI}{The observed omnibus test statistic.}
\item{OMNI_pvalue}{The p-value of the OMNI test}
\item{err_code}{Sometimes if your p-value is very small (< 1*10^(-10)), R may run into numerical
issues. This message will alert you if such a situation occurs.}
}
\description{
Computes the omnibus test statistic combining GBJ, GHC, minP, and SKAT.
This version of the function assumes you have the individual factor data (i.e. genotypes)
for each subject.  If you only have summary statistics, use omni_ss().
You WILL NOT be able to use this function unless you have also loaded
the SKAT package (install.packages("SKAT"); library(SKAT)).
}
\examples{
factor_matrix <- matrix(data=rbinom(n=1000, size=2, prob=0.3), ncol=5)
Y <- rnorm(n=200)
null_mod <- glm(Y ~ 1)
OMNI_individual(null_model=null_mod, factor_matrix=factor_matrix,
link_function='linear', num_boots=5)
}

