% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBcurves.R
\name{yields}
\alias{yields}
\title{Yield Curves Dataset}
\source{
The dataset of Brazil, China, and Russia are obtained from <http://www.b3.com.br/>, <http://yield.chinabond.com.cn>, and <https://www.cbr.ru>, respectively.
}
\usage{
yields(init, fin, mty, ctry)
}
\arguments{
\item{init}{Initial date in format "YYYY-MM-DD"}

\item{fin}{Final date in format "YYYY-MM-DD"}

\item{mty}{Maturities specified by months}

\item{ctry}{Countries available: "BR", "CN" or "RU"}
}
\value{
A matrix that contains daily yield curves in percent in each row and maturities in months by columns.
}
\description{
This function downloads daily yield curves data of Brazil, China, and Russia. If necessary, it interpolates with spline function for unavailable maturities.
}
\examples{

init <- "2020-05-10"
fin <- "2020-05-17"
mty <- c(3,6,12,120,360)
ctry <- "BR"

\dontrun{
yields(init = init, fin = fin, mty = mty, ctry = ctry)
}
}
