% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cmsc_sw}
\alias{cmsc_sw}
\alias{cmsc_e1_sw}
\alias{cmsc_e2_sw}
\alias{gcsm_sw}
\alias{ssim_sw}
\title{Composite similarity on spatial windows}
\usage{
cmsc_sw(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  ksize = 9,
  globe = FALSE,
  comp = "si"
)

cmsc_e1_sw(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  ksize = 9,
  globe = FALSE,
  comp = "si"
)

cmsc_e2_sw(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  ksize = 9,
  globe = FALSE,
  comp = "si"
)

gcsm_sw(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  ksize = 9,
  globe = FALSE,
  comp = "si"
)

ssim_sw(
  x,
  y,
  rescale = FALSE,
  xmin = NA_real_,
  xmax = NA_real_,
  ymin = NA_real_,
  ymax = NA_real_,
  ksize = 11,
  sigma = 1.5,
  globe = FALSE,
  comp = "si"
)
}
\arguments{
\item{x}{A vector.}

\item{y}{The other vector.}

\item{rescale}{Rescale or not before computation.}

\item{xmin, xmax, ymin, ymax}{Normalization parameters. If \code{NA}, are calculated
from the ranges of \code{x} and \code{y}, respectively. See Details.}

\item{ksize}{Side length of spatial windows.}

\item{globe}{Are data at the global scale? If \code{TRUE}, two vertical borders
will be padded before computation.}

\item{comp}{Variable to return. If \code{"si"}, the composite measure, if
\code{"s1"},\code{"s2"} or \code{"s3"}, the corresponding component.}

\item{sigma}{Standard deviation of Gaussian weighting function
depending on the distance between the cell and kernel center.}
}
\value{
A matrix.
}
\description{
Compute composite measures, GCSM, CMSC or SSIM, on spatial windows.
}
\details{
These functions slide the spatial window over space. Missing values are
omitted. Normalization parameters are used to rescale \code{x} and \code{y}, and
determine the global minimum (min) and maximum (max). If \code{rescale} is
\code{TRUE}, \code{x} and \code{y} are rescaled to \code{(x-xmin)/(xmax-xmin)} and
\code{(y-ymin)/(ymax-ymin)}; and set \code{min=0}, \code{max=1}. If \code{FALSE},
\code{min=min(xmin,ymin)}, \code{max=max(xmax,ymax)}. OpenMP is used for parallel
computing.
}
\examples{
x = matrix(runif(36), nrow = 6, ncol = 6)

gcsm_sw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1, ksize = 3)
cmsc_sw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1, ksize = 3)
ssim_sw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1, ksize = 3)
}
