% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormEventCounts.R
\name{NormEventCounts}
\alias{NormEventCounts}
\title{Scale event counts}
\usage{
NormEventCounts(x, unit_analysis, var_name = "norming_vars")
}
\arguments{
\item{x}{data.frame, a GDELT data.frame.}

\item{unit_analysis}{character, default is country_day; other options: country_month, country_year, day, month, year}

\item{var_name}{character, base name for the new count variables}
}
\value{
data.frame
}
\description{
Scale event counts based on the unit of analysis.
}
\details{
For \code{unit_analysis}, day and country-day put out a data set where date
is of class \sQuote{date}.  All other options put out a data set where year
or month is integer (this needs to be unified in a later version).
}
\examples{
\dontrun{
GDELT_subset_data <- GetGDELT("2013-06-01", "2013-06-07",
  (ActionGeo_CountryCode=="AF" | ActionGeo_CountryCode=="US") & EventCode>=140 & EventCode<150,
  local_folder="~/gdeltdata")
GDELT_normed_data <- NormEventCounts(x = GDELT_subset_data, 
  unit_analysis="day", 
  var_name="protest")}
}
\references{
GDELT: Global Data on Events, Location and Tone, 1979-2012.  
Presented at the 2013 meeting of the International Studies Association
in San Francisco, CA.
\url{https://www.gdeltproject.org/}
}
\author{
\tabular{ll}{
  Oskar N.T. Thoms \tab \email{othoms@princeton.edu}\cr
  Stephen R. Haptonstahl \tab \email{srh@haptonstahl.org}\cr
  John Beieler \tab \email{jub270@psu.edu}\cr
}
}
