% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemparm.GDINA.R
\name{itemparm}
\alias{itemparm}
\title{extract lower-order structural (item) parameters}
\usage{
itemparm(object, what = c("catprob", "gs", "delta", "rrum", "itemprob",
  "LCprob"), withSE = FALSE, SE.type = 2, digits = 4, ...)
}
\arguments{
\item{object}{estimated GDINA object returned from \code{\link{GDINA}}}

\item{what}{what to show; It can be \code{"itemprob"} for
item success probabilities of each reduced attribute pattern, \code{"catprob"} for
category success probabilities of each reduced attribute pattern, \code{"LCprob"} for
item success probabilities of each attribute pattern, \code{"gs"} for guessing and slip parameters,
\code{"delta"} for delta parameters, \code{"rrum"} for RRUM parameters when items
are estimated using RRUM. The default is \code{"catprob"}.}

\item{withSE}{show standard errors or not?}

\item{SE.type}{Type of standard errors. Can be 1, 2 or 3, indicating outer product of gradient (OPG) estimates
based on itemwise, incomplete or complete information matrix. See Philipp, Strobl, de la Torre, & Zeileis (2016).
Currently, the OPG method based on the complete information matrix assumes that all latent classes are identifiable.}

\item{digits}{how many decimal places for the ouput?}

\item{...}{additional arguments}
}
\description{
Function to extract various item parameters, including \code{"itemprob"} for
item success probabilities of each reduced attribute pattern, \code{"catprob"} for
category success probabilities of each reduced attribute pattern, \code{"LCprob"} for
item success probabilities of each attribute pattern,\code{"gs"} for guessing and slip parameters,
\code{"delta"} for delta parameters, \code{"rrum"} for RRUM parameters when items
are estimated using RRUM. Standard errors can be estimated if \code{withSE = TRUE}.
See \code{\link{GDINA}} for examples.
}
\references{
Philipp, M., Strobl, C., de la Torre, J., & Zeileis, A.(2016). On the estima-tion of standard errors in cognitive diagnosis models (Working Papers).   Fac-ulty  of  Economics  and  Statistics,  University  of  Innsbruck.Retrieved  from \url{http://EconPapers.repec.org/RePEc:inn:wpaper:2016-25}
}
\author{
{Wenchao Ma, Rutgers University, \email{wenchao.ma@rutgers.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
