% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural_function.R
\name{structural_function}
\alias{structural_function}
\title{Structural Function}
\usage{
structural_function(theta, transition.interval, f1, f2, ...)
}
\arguments{
\item{theta}{the track switching parameter, which is a scalar.}

\item{transition.interval}{a 2-vector.}

\item{f1}{the first function (or a value).}

\item{f2}{the second function (or a value).}

\item{...}{parameters of f1 and f2.}
}
\value{
The value of the structural function.
}
\description{
A structured function is a function generated by connecting two
functions through a transition region.
This function calculates the value of a structured function.
}
\examples{
x <- seq(1, 5, 0.1)
y <- c()
for (theta in x) y <- c(y, structural_function(theta, c(2, 3), log, sqrt, theta))
plot(x, y)
lines(x, log(x), col = "blue")
lines(x, sqrt(x), col = "red")

####
f <- function(theta) {
p <- c(1, 1)
structural_function(
  theta,
  c(15, 20),
  function(p) CD_A(alpha = 5, Beta = c(0.6, 0.4), p),
  function(p) CD_A(alpha = 15, Beta = c(0.6, 0.4), p),
  p
)
}

tmp <- sapply(1:25,f)
matplot(t(tmp), type="l")
}
