% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/gemIntertemporal_EndogenousEquilibriumInterestRate__ForeignExchangeRate.R
\name{gemIntertemporal_EndogenousEquilibriumInterestRate_ForeignExchangeRate}
\alias{gemIntertemporal_EndogenousEquilibriumInterestRate_ForeignExchangeRate}
\title{An Example Illustrating Endogenous Equilibrium Interest Rates and Foreign Exchange Rates in a Two-country (Timeline) Transitional Equilibrium Path}
\usage{
gemIntertemporal_EndogenousEquilibriumInterestRate_ForeignExchangeRate(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
This example illustrates (endogenous) equilibrium primitive interest rates and foreign exchange rates in a two-country transitional equilibrium path.
}
\examples{
\donttest{
vm <- 1 # the velocity of money
eis <- 0.8 # the elasticity of intertemporal substitution
Gamma.beta <- 10 / 11 # the subjective discount factor
gr <- 0 # the growth rate
money1.supply <- 600
money2.supply <- 100
np <- 20 # the number of economic periods

sserr(eis, Gamma.beta, gr, prepaid = TRUE)

f <- function(ir = rep(0.1, 2 * np - 2), return.ge = FALSE,
              y1.wheat = 10, # 49.24 #49.79 the wheat supply in the first period
              y1.iron = 5 # 41.32 #45.45 the iron supply in the first period
) {
  ir1 <- head(ir, np - 1)
  ir2 <- tail(ir, np - 1)

  n <- 2 * np + 2 * (np - 1) + 2 # the number of commodity kinds
  m <- 2 * (np - 1) + 4 # the number of agent kinds

  names.commodity <- c(
    paste0("wheat", 1:np),
    paste0("lab1.", 1:(np - 1)),
    "money1",
    paste0("iron", 1:np),
    paste0("lab2.", 1:(np - 1)),
    "money2"
  )

  names.agent <- c(
    paste0("firm.wheat", 1:(np - 1)),
    "laborer1", "moneyOwner1",
    paste0("firm.iron", 1:(np - 1)),
    "laborer2", "moneyOwner2"
  )

  # the exogenous supply matrix.
  S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))
  S0Exg[paste0("lab1.", 1:(np - 1)), "laborer1"] <- 100 * (1 + gr)^(0:(np - 2))
  S0Exg["money1", "moneyOwner1"] <- money1.supply
  S0Exg["wheat1", "laborer1"] <- y1.wheat

  S0Exg[paste0("lab2.", 1:(np - 1)), "laborer2"] <- 100 * (1 + gr)^(0:(np - 2))
  S0Exg["money2", "moneyOwner2"] <- money2.supply
  S0Exg["iron1", "laborer2"] <- y1.iron

  # the output coefficient matrix.
  B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))
  for (k in 1:(np - 1)) {
    B[paste0("wheat", k + 1), paste0("firm.wheat", k)] <- 1
    B[paste0("iron", k + 1), paste0("firm.iron", k)] <- 1
  }

  dstl.firm.wheat <- dstl.firm.iron <- list()
  for (k in 1:(np - 1)) {
    dstl.firm.wheat[[k]] <- node_new(
      "prod",
      type = "FIN", rate = c(1, ir1[k] / vm),
      "cc1", "money1"
    )
    node_set(dstl.firm.wheat[[k]], "cc1",
      type = "CD", alpha = 1, beta = c(0.5, 0.5),
      paste0("iron", k), paste0("lab1.", k)
    )

    dstl.firm.iron[[k]] <- node_new(
      "prod",
      type = "FIN", rate = c(1, ir2[k] / vm),
      "cc1", "money2"
    )
    node_set(dstl.firm.iron[[k]], "cc1",
      type = "CD", alpha = 1, beta = c(0.5, 0.5),
      paste0("iron", k), paste0("lab2.", k)
    )
  }

  dst.laborer1 <- node_new(
    "util",
    type = "CES", es = eis,
    alpha = 1, beta = prop.table(Gamma.beta^(1:np)),
    paste0("cc", 1:(np - 1)), paste0("wheat", np)
  )
  for (k in 1:(np - 1)) {
    node_set(dst.laborer1, paste0("cc", k),
      type = "FIN", rate = c(1, ir1[k] / vm),
      paste0("wheat", k), "money1"
    )
  }

  dst.moneyOwner1 <- node_new(
    "util",
    type = "CES", es = eis,
    alpha = 1, beta = prop.table(Gamma.beta^(1:(np - 1))),
    paste0("cc", 1:(np - 1))
  )
  for (k in 1:(np - 1)) {
    node_set(dst.moneyOwner1, paste0("cc", k),
      type = "FIN", rate = c(1, ir1[k] / vm),
      paste0("wheat", k), "money1"
    )
  }

  dst.laborer2 <- node_new(
    "util",
    type = "CES", es = eis,
    alpha = 1, beta = prop.table(Gamma.beta^(1:np)),
    paste0("cc", 1:(np - 1)), paste0("iron", np)
  )

  for (k in 1:(np - 1)) {
    node_set(dst.laborer2, paste0("cc", k),
      type = "FIN", rate = c(1, ir2[k] / vm),
      paste0("wheat", k), "money2"
    )
  }

  dst.moneyOwner2 <- node_new(
    "util",
    type = "CES", es = eis,
    alpha = 1, beta = prop.table(Gamma.beta^(1:(np - 1))),
    paste0("cc", 1:(np - 1))
  )
  for (k in 1:(np - 1)) {
    node_set(dst.moneyOwner2, paste0("cc", k),
      type = "FIN", rate = c(1, ir2[k] / vm),
      paste0("wheat", k), "money2"
    )
  }

  ge <- sdm2(
    A = c(
      dstl.firm.wheat, dst.laborer1, dst.moneyOwner1,
      dstl.firm.iron, dst.laborer2, dst.moneyOwner2
    ),
    B = B,
    S0Exg = S0Exg,
    names.commodity = names.commodity,
    names.agent = names.agent,
    numeraire = "wheat1",
    policy = makePolicyTailAdjustment(
      ind = rbind(
        c(np - 1, np),
        c(2 * np, 2 * (np - 1) + 3)
      ),
      gr = gr
    )
  )

  tmp <- rowSums(ge$SV)

  ts1.exchange.value <- tmp[paste0("wheat", 1:(np - 1))] + tmp[paste0("lab1.", 1:(np - 1))]
  ir1.new <- ts1.exchange.value[1:(np - 2)] / ts1.exchange.value[2:(np - 1)] - 1
  ir1.new <- pmax(1e-6, ir1.new)
  ir1.new[np - 1] <- ir1.new[np - 2]

  ir1 <- c(ir1 * ratio_adjust(ir1.new / ir1, 0.3))
  cat("ir1: ", ir1, "\n")


  ts2.exchange.value <- tmp[paste0("iron", 1:(np - 1))] + tmp[paste0("lab2.", 1:(np - 1))]
  ir2.new <- ts2.exchange.value[1:(np - 2)] / ts2.exchange.value[2:(np - 1)] - 1
  ir2.new <- pmax(1e-6, ir2.new)
  ir2.new[np - 1] <- ir2.new[np - 2]

  ir2 <- c(ir2 * ratio_adjust(ir2.new / ir2, 0.3))
  cat("ir2: ", ir2, "\n")

  if (return.ge) {
    ge$ts1.exchange.value <- unname(ts1.exchange.value)
    ge$ts2.exchange.value <- unname(ts2.exchange.value)
    ge$ts.forex <- unname((ge$ts2.exchange.value / money2.supply) /
      (ge$ts1.exchange.value / money1.supply))
    return(ge)
  } else {
    return(c(ir1, ir2))
  }
}

## Calculate equilibrium interest rates.
## Warning: Running the program below takes about several minutes.
# mat.ir <- iterate(rep(0.1, 2*np - 2), f, tol = 1e-4)
# sserr(eis, Gamma.beta, gr, prepaid = TRUE)

## Below are the calculated equilibrium interest rates.
ir1 <- c(
  0.2218, 0.1888, 0.1455, 0.1228, 0.1115, 0.1058, 0.1029, 0.1015, 0.1008,
  0.1004, 0.1002, 0.1001, 0.1001, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000
)
ir2 <- c(
  0.1292, 0.1080, 0.1037, 0.1019, 0.1010, 0.1005, 0.1003, 0.1001, 0.1001,
  0.1000, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000, 0.1000
)

ge <- f(c(ir1, ir2), return.ge = TRUE)
plot(ge$z[1:(np - 1)], type = "o", ylab = "wheat output")
ge$ts.forex

## the corresponding sequential model with the same steady-state equilibrium.
np <- 5
ge.ss <- f(return.ge = TRUE, y1.wheat = 49.24, y1.iron = 41.32)

ir <- dividend.rate <- 0.1

dst.firm.wheat <- node_new("output",
  type = "FIN", rate = c(1, ir / vm, (1 + ir) * dividend.rate),
  "cc1", "money1", "equity.share.wheat"
)
node_set(dst.firm.wheat, "cc1",
  type = "CD", alpha = 1,
  beta = c(0.5, 0.5),
  "iron", "lab1"
)

dst.firm.iron <- node_new("output",
  type = "FIN", rate = c(1, ir / vm, (1 + ir) * dividend.rate),
  "cc1", "money2", "equity.share.iron"
)
node_set(dst.firm.iron, "cc1",
  type = "CD", alpha = 1,
  beta = c(0.5, 0.5),
  "iron", "lab2"
)

dst.laborer1 <- node_new("util",
  type = "FIN", rate = c(1, interest.rate = 0.1),
  "cc1", "money1"
)
node_set(dst.laborer1, "cc1",
  type = "Leontief", a = 1,
  "wheat"
)

dst.moneyOwner1 <- Clone(dst.laborer1)

dst.laborer2 <- Clone(dst.laborer1)
node_replace(dst.laborer2, "money1", "money2")

dst.moneyOwner2 <- Clone(dst.laborer2)

ge <- sdm2(
  A = list(
    dst.firm.wheat, dst.laborer1, dst.moneyOwner1,
    dst.firm.iron, dst.laborer2, dst.moneyOwner2
  ),
  B = matrix(c(
    1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0
  ), 8, 6, TRUE),
  S0Exg = matrix(c(
    NA, NA, NA, NA, NA, NA,
    NA, 100, NA, NA, NA, NA,
    NA, NA, 600, NA, NA, NA,
    NA, 100, NA, NA, NA, NA,
    NA, NA, NA, NA, NA, NA,
    NA, NA, NA, NA, 100, NA,
    NA, NA, NA, NA, NA, 100,
    NA, NA, NA, NA, 100, NA
  ), 8, 6, TRUE),
  names.commodity = c(
    "wheat", "lab1", "money1", "equity.share.wheat",
    "iron", "lab2", "money2", "equity.share.iron"
  ),
  names.agent = c(
    "firm1", "laborer1", "moneyOwner1",
    "firm2", "laborer2", "moneyOwner2"
  ),
  numeraire = c("money1" = 0.1) # interest.rate
)

ge.ss$ts.forex
ge$p["money2"] / ge$p["money1"] # the foreign exchange rate

## Calculate equilibrium interest rates.
## Warning: Running the program below takes about several minutes.
# np <- 20
# gr <- 0.03
# mat.ir <- iterate(rep(0.1, 2*np - 2), f, tol = 1e-4)
# sserr(eis, Gamma.beta, gr, prepaid = TRUE)

## a steady-state equilibrium with an exogenous interest rate 0.1.
## The endogenous equilibrium interest rate and dividend rate are 0.
## See also CGE::Example7.6.
eis <- 1 # the elasticity of intertemporal substitution
Gamma.beta <- 1 # the subjective discount factor
gr <- 0 # the growth rate
money1.supply <- 600
money2.supply <- 100
np <- 20 # the number of economic periods

np <- 5
ge.ss <- f(return.ge = TRUE, y1.wheat = 49.79, y1.iron = 45.45)
ge.ss$z
ge.ss$ts.forex
}
}
\seealso{
\code{\link{gemIntertemporal_EndogenousEquilibriumInterestRate}}
}
