% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes.r
\name{rank_envelope}
\alias{rank_envelope}
\title{The rank envelope test}
\usage{
rank_envelope(curve_set, type = "rank", ...)
}
\arguments{
\item{curve_set}{A curve_set (see \code{\link{create_curve_set}}) or an \code{envelope}
object of \pkg{spatstat}. If an envelope object is given, it must contain the summary
functions from the simulated patterns which can be achieved by setting
savefuns = TRUE when calling the function of \pkg{spatstat}.}

\item{type}{The type of the global envelope with current options for "rank", "erl", "cont" and "area".
If "rank", the global rank envelope accompanied by the p-interval is given (Myllymäki et al., 2017).
If "erl", the global rank envelope based on extreme rank lengths accompanied by the extreme rank
length p-value is given (Myllymäki et al., 2017, Mrkvička et al., 2018). See details and additional
sections thereafter.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.}
}
\value{
An object of class \code{global_envelope} of \code{combined_global_envelope}
which can be printed and plotted directly. See \code{\link{global_envelope_test}} for more details.
}
\description{
The rank envelope test, p-values and global envelopes.
The test corresponds to the global envelope test that can be carriet out by
\code{\link{global_envelope_test}} by specifying the \code{type} for which the options
\code{"rank"}, \code{"erl"}, \code{"cont"} and \code{"area"} are available. The last
three are modifications of the first one to treat the ties in the extreme rank ordering
used in \code{"rank"}. This function is kept for historical reasons.
}
\details{
The \code{"rank"} envelope test is a completely non-parametric test, which provides
the 100(1-alpha)\% global envelope for the chosen test function T(r) on
the chosen interval of distances and associated p-values.
The other three types are solutions to break the ties in the extreme ranks
on which the \code{"rank"} envelope test is based on.

Note: The method to break ties for the global \code{type = "rank"} envelope
(Myllymäki et al., 2017) can be done by the argument \code{ties} with default
to \code{ties = "erl"} corresponding to the extreme rank length breaking of ties.
In this case the global envelope corresponds to the extreme rank measure.
If instead choosing \code{type} to be \code{"erl"}, \code{"cont"} or \code{"area"},
then the global envelope corresponds to these measures.
}
\section{Number of simulations}{

The global \code{"erl"}, \code{"cont"}, \code{"area"} envelope tests allow 
in principle a lower number of simulations to be used than the global \code{"rank"} test
based on extreme ranks.
However, if feasible, we recommend some thousands of simulations in any case to achieve
a good power and repeatability of the test.
For the global \code{"rank"} envelope test, Myllymäki et al. (2017) recommended to use
at least 2500 simulations for testing at the significance level alpha = 0.05 for single
function tests, experimented with summary functions for point processes.
}

\examples{
# See ?global_envelope_test for more examples

## Testing complete spatial randomness (CSR)
#-------------------------------------------
if(require("spatstat", quietly=TRUE)) {
  X <- unmark(spruces)
  \donttest{nsim <- 2499 # Number of simulations}
  \dontshow{nsim <- 19 # Number of simulations for testing}
  # Generate nsim simulations under CSR, calculate centred L-function for the data and simulations
  env <- envelope(X, fun="Lest", nsim=nsim, savefuns=TRUE,
                  correction="translate", transform = expression(.-r),
                  simulate=expression(runifpoint(ex=X)))
  # The rank envelope test
  res <- rank_envelope(env)
  # Plot the result.
  plot(res)

  ## Advanced use:
  # Choose the interval of distances [r_min, r_max] (at the same time create a curve_set from 'env')
  curve_set <- crop_curves(env, r_min=1, r_max=7)
  # Do the rank envelope test
  res <- rank_envelope(curve_set); plot(res)
}
}
\references{
Myllymäki, M., Mrkvička, T., Grabarnik, P., Seijo, H. and Hahn, U. (2017). Global envelope tests for spatial point patterns. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 79: 381–404. doi: 10.1111/rssb.12172

Mrkvička, T., Myllymäki, M. and Hahn, U. (2017). Multiple Monte Carlo testing, with applications in spatial point processes. Statistics & Computing 27 (5): 1239-1255. doi: 10.1007/s11222-016-9683-9

Mrkvička, T., Myllymäki, M., Jilek, M. and Hahn, U. (2020) A one-way ANOVA test for functional data with graphical interpretation. Kybernetika 56 (3), 432-458. doi: 10.14736/kyb-2020-3-0432
}
\seealso{
\code{\link{global_envelope_test}}
}
