% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GETD.R
\name{GETD}
\alias{GETD}
\title{Generalized Extended Triangular Designs}
\usage{
GETD(n, m)
}
\arguments{
\item{n}{It is a natural number such that n >= 2m ; m >= 2}

\item{m}{It is a natural number such that m >= 2}
}
\value{
This function for generates an m-associate (m >= 2) class PBIB design and its parameters, based on Generalized Triangular (GT) Association Scheme, along with its Information matrix, Average variance factor and canonical efficiency factor.
}
\description{
This package contains functions named GETD() for generating a m-associate (m >= 2) class PBIB designs and its parameters based on Generalized Triangular (GT) Association Scheme. It also calculates the Information matrix, Average variance factor and canonical efficiency factor of the generated design.
}
\examples{
library(GETdesigns)
GETD(6,2)
}
\references{
1) R.C. Bose, K.R. Nair (1939)< https://www.jstor.org/stable/40383923>" Partially balanced incomplete block designs ".

2) R.C. Bose, T. Shimamoto (1952)<doi:10.1080/01621459.1952.10501161> "Classification and analysis of partially balanced incomplete block designs with two associate classes".
}
